/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.codec;

import io.r2dbc.postgresql.api.PostgresqlConnection;
import io.r2dbc.postgresql.codec.PostgresTypeIdentifier;
import io.r2dbc.postgresql.codec.PostgresqlObjectId;
import io.r2dbc.postgresql.util.Assert;
import io.r2dbc.spi.Row;
import io.r2dbc.spi.RowMetadata;
import io.r2dbc.spi.Type;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import org.jspecify.annotations.Nullable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class PostgresTypes {
    public static final int NO_SUCH_TYPE = -1;
    private static final String SELECT_PG_TYPE = "SELECT pg_type.oid, pg_type.*   FROM pg_catalog.pg_type   LEFT   JOIN (select ns.oid as nspoid, ns.nspname, r.r           from pg_namespace as ns           join ( select s.r, (current_schemas(false))[s.r] as nspname                    from generate_series(1, array_upper(current_schemas(false), 1)) as s(r) ) as r          using ( nspname )        ) as sp     ON sp.nspoid = typnamespace  WHERE typname %s %s  ORDER BY sp.r, pg_type.oid DESC %s;";
    private static final Pattern TYPENAME = Pattern.compile("[a-zA-Z0-9_]+");
    private final PostgresqlConnection connection;

    private PostgresTypes(PostgresqlConnection connection) {
        this.connection = connection;
    }

    public static PostgresTypes from(PostgresqlConnection connection) {
        return new PostgresTypes(Assert.requireNonNull(connection, "connection must not be null"));
    }

    public Mono<PostgresType> lookupType(String typeName) {
        if (!TYPENAME.matcher(Assert.requireNonNull(typeName, "typeName must not be null")).matches()) {
            throw new IllegalArgumentException(String.format("Invalid typename %s", typeName));
        }
        return this.connection.createStatement(String.format(SELECT_PG_TYPE, "=", "'" + typeName + "'", "LIMIT 1")).execute().flatMap(it -> it.map(PostgresTypes::createType)).singleOrEmpty();
    }

    public Flux<PostgresType> lookupTypes(Iterable<String> typeNames) {
        StringJoiner joiner = new StringJoiner(",", "(", ")");
        AtomicBoolean hasType = new AtomicBoolean();
        typeNames.forEach(typeName -> {
            if (!TYPENAME.matcher(Assert.requireNonNull(typeName, "typeName must not be null")).matches()) {
                throw new IllegalArgumentException(String.format("Invalid typename %s", typeName));
            }
            hasType.set(true);
            joiner.add("'" + typeName + "'");
        });
        if (!hasType.get()) {
            return Flux.empty();
        }
        return this.connection.createStatement(String.format(SELECT_PG_TYPE, "IN", joiner, "")).execute().flatMap(it -> it.map(PostgresTypes::createType));
    }

    private static PostgresType createType(Row row, RowMetadata rowMetadata) {
        Long oid = (Long)row.get("oid", Long.class);
        String typname = (String)row.get("typname", String.class);
        String typcategory = (String)row.get("typcategory", String.class);
        Long typarrayOid = rowMetadata.contains("typarray") ? (Long)row.get("typarray", Long.class) : null;
        long unsignedTyparray = typarrayOid != null ? typarrayOid : -1L;
        int typarray = typarrayOid != null ? PostgresqlObjectId.toInt(typarrayOid) : -1;
        return new PostgresType(PostgresqlObjectId.toInt(oid), oid, typarray, unsignedTyparray, typname, typcategory);
    }

    public static class PostgresType
    implements Type,
    PostgresTypeIdentifier {
        private final int oid;
        private final long unsignedOid;
        private final int typarray;
        private final long unsignedTyparray;
        private final String name;
        private final String category;
        private final @Nullable PostgresqlObjectId objectId;

        public PostgresType(int oid, long unsignedOid, int typarray, long unsignedTyparray, String name, String category) {
            this.oid = oid;
            this.unsignedOid = unsignedOid;
            this.typarray = typarray;
            this.unsignedTyparray = unsignedTyparray;
            this.name = name;
            this.category = category;
            this.objectId = PostgresqlObjectId.isValid(oid) ? PostgresqlObjectId.valueOf(oid) : null;
        }

        @Override
        public int getObjectId() {
            return this.getOid();
        }

        public PostgresType asArrayType() {
            if (this.isArray()) {
                return this;
            }
            if (this.typarray > 0) {
                return new PostgresType(this.typarray, this.unsignedTyparray, this.typarray, this.unsignedTyparray, this.name, this.category);
            }
            throw new IllegalStateException("No array type available for " + this);
        }

        public int getOid() {
            return this.oid;
        }

        public Class<?> getJavaType() {
            return this.objectId != null ? this.objectId.getJavaType() : Object.class;
        }

        public int getArrayObjectId() {
            return this.typarray;
        }

        public long getUnsignedObjectId() {
            return this.unsignedOid;
        }

        public long getUnsignedArrayObjectId() {
            return this.unsignedTyparray;
        }

        public String getName() {
            return this.name;
        }

        public boolean isArray() {
            return "A".equals(this.category);
        }

        public boolean isBoolean() {
            return "B".equals(this.category);
        }

        public boolean isComposite() {
            return "C".equals(this.category);
        }

        public boolean isDateTime() {
            return "D".equals(this.category);
        }

        public boolean isEnum() {
            return "E".equals(this.category);
        }

        public boolean isGeometric() {
            return "G".equals(this.category);
        }

        public boolean isNetworkAddress() {
            return "I".equals(this.category);
        }

        public boolean isNumeric() {
            return "N".equals(this.category);
        }

        public boolean isPseudo() {
            return "P".equals(this.category);
        }

        public boolean isString() {
            return "S".equals(this.category);
        }

        public boolean isTimespan() {
            return "T".equals(this.category);
        }

        public boolean isUserDefinedType() {
            return "U".equals(this.category);
        }

        public boolean isBitString() {
            return "V".equals(this.category);
        }

        public boolean isUnknown() {
            return "X".equals(this.category);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof PostgresType)) {
                return false;
            }
            PostgresType that = (PostgresType)o;
            return this.oid == that.oid && this.unsignedOid == that.unsignedOid && this.typarray == that.typarray && this.unsignedTyparray == that.unsignedTyparray && Objects.equals(this.name, that.name) && Objects.equals(this.category, that.category);
        }

        public int hashCode() {
            return Objects.hash(this.oid, this.unsignedOid, this.typarray, this.unsignedTyparray, this.name, this.category);
        }

        public String toString() {
            return "PostgresType{oid=" + this.oid + "unsignedOid=" + this.unsignedOid + "typarray=" + this.typarray + "unsignedTyparray=" + this.unsignedTyparray + ", name='" + this.name + '\'' + ", category='" + this.category + '\'' + '}';
        }
    }
}

