/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.api.extension.listener;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Set;
import org.powermock.api.easymock.EasyMockConfiguration;
import org.powermock.api.easymock.annotation.MockNice;
import org.powermock.api.easymock.annotation.MockStrict;
import org.powermock.api.extension.listener.AnnotationGlobalMetadata;
import org.powermock.api.extension.listener.AnnotationMockCreator;
import org.powermock.api.extension.listener.AnnotationMockCreatorFactory;
import org.powermock.api.extension.listener.AnnotationMockMetadata;
import org.powermock.api.extension.listener.AnnotationMockScanner;
import org.powermock.api.extension.listener.TestSubjectInjector;
import org.powermock.core.classloader.annotations.Mock;
import org.powermock.reflect.Whitebox;

public class EasyMockAnnotationSupport {
    private final Object testInstance;
    private final AnnotationMockCreatorFactory annotationMockCreatorFactory;
    private final AnnotationGlobalMetadata globalMetadata;
    private final EasyMockConfiguration easyMockConfiguration;

    public EasyMockAnnotationSupport(Object testInstance) {
        this.testInstance = testInstance;
        this.annotationMockCreatorFactory = new AnnotationMockCreatorFactory();
        this.globalMetadata = new AnnotationGlobalMetadata();
        this.easyMockConfiguration = EasyMockConfiguration.getConfiguration();
    }

    public void injectMocks() throws Exception {
        this.injectStrictMocks();
        this.injectNiceMocks();
        this.injectDefaultMocks();
        this.injectTestSubjectMocks();
    }

    protected void injectStrictMocks() throws Exception {
        this.inject(this.testInstance, MockStrict.class, this.annotationMockCreatorFactory.createStrictMockCreator());
    }

    protected void injectNiceMocks() throws Exception {
        this.inject(this.testInstance, MockNice.class, this.annotationMockCreatorFactory.createNiceMockCreator());
    }

    protected void injectDefaultMocks() throws Exception {
        this.inject(this.testInstance, org.powermock.api.easymock.annotation.Mock.class, this.annotationMockCreatorFactory.createDefaultMockCreator());
        this.inject(this.testInstance, Mock.class, this.annotationMockCreatorFactory.createDefaultMockCreator());
    }

    protected void injectTestSubjectMocks() throws IllegalAccessException {
        if (this.easyMockConfiguration.isTestSubjectSupported()) {
            TestSubjectInjector testSubjectInjector = new TestSubjectInjector(this.testInstance, this.globalMetadata);
            testSubjectInjector.injectTestSubjectMocks();
        }
    }

    protected void inject(Object injectCandidateInstance, Class<? extends Annotation> annotation, AnnotationMockCreator mockCreator) throws Exception {
        AnnotationMockScanner scanner = new AnnotationMockScanner(annotation);
        List<AnnotationMockMetadata> mocksMetadata = scanner.scan(injectCandidateInstance);
        this.globalMetadata.add(mocksMetadata);
        for (AnnotationMockMetadata mockMetadata : mocksMetadata) {
            this.injectMock(injectCandidateInstance, mockMetadata, mockCreator, new AnnotationInjectFieldSearcher());
        }
    }

    protected void injectMock(Object injectCandidateInstance, AnnotationMockMetadata mockMetadata, AnnotationMockCreator mockCreator, InjectFieldSearcher fieldSearch) throws IllegalAccessException {
        Object mock = this.createMock(mockCreator, mockMetadata);
        Field field = fieldSearch.findField(injectCandidateInstance, mockMetadata);
        if (field != null && mock != null) {
            field.setAccessible(true);
            field.set(injectCandidateInstance, mock);
        }
    }

    protected Object createMock(AnnotationMockCreator mockCreator, AnnotationMockMetadata mockMetadata) {
        if (mockMetadata.getMock() == null) {
            Object mock = mockCreator.createMockInstance(mockMetadata.getType(), mockMetadata.getMethods());
            mockMetadata.setMock(mock);
        }
        return mockMetadata.getMock();
    }

    protected static class AnnotationInjectFieldSearcher
    implements InjectFieldSearcher {
        protected AnnotationInjectFieldSearcher() {
        }

        @Override
        public Field findField(Object instance, AnnotationMockMetadata mockMetadata) {
            Set candidates = Whitebox.getFieldsAnnotatedWith((Object)instance, mockMetadata.getAnnotation(), (Class[])new Class[0]);
            if (candidates.size() == 1) {
                return (Field)candidates.iterator().next();
            }
            return null;
        }
    }

    protected static interface InjectFieldSearcher {
        public Field findField(Object var1, AnnotationMockMetadata var2);
    }
}

