/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.api.mockito.internal.mockmaker;

import java.util.List;
import org.mockito.internal.InternalMockHandler;
import org.mockito.internal.creation.MockSettingsImpl;
import org.mockito.internal.stubbing.InvocationContainer;
import org.mockito.internal.util.MockNameImpl;
import org.mockito.invocation.Invocation;
import org.mockito.invocation.MockHandler;
import org.mockito.mock.MockCreationSettings;
import org.mockito.mock.MockName;
import org.mockito.plugins.MockMaker;
import org.mockito.stubbing.Answer;
import org.mockito.stubbing.VoidMethodStubbable;
import org.powermock.api.mockito.repackaged.CglibMockMaker;
import org.powermock.core.classloader.MockClassLoader;

public class PowerMockMaker
implements MockMaker {
    private final MockMaker cglibMockMaker = new CglibMockMaker();

    public <T> T createMock(MockCreationSettings<T> settings, MockHandler handler) {
        Object mock = this.cglibMockMaker.createMock(settings, handler);
        ClassLoader classLoader = this.cglibMockMaker.getClass().getClassLoader();
        if (classLoader instanceof MockClassLoader) {
            MockClassLoader mcl = (MockClassLoader)classLoader;
            mcl.cache(mock.getClass());
        }
        return (T)mock;
    }

    public MockHandler getHandler(Object mock) {
        if (mock instanceof Class) {
            return new PowerMockInternalMockHandler((Class)mock);
        }
        return this.cglibMockMaker.getHandler(mock);
    }

    public void resetMock(Object mock, MockHandler newHandler, MockCreationSettings settings) {
        this.cglibMockMaker.resetMock(mock, newHandler, settings);
    }

    public MockMaker.TypeMockability isTypeMockable(Class<?> type) {
        return this.cglibMockMaker.isTypeMockable(type);
    }

    private static class PowerMockInternalMockHandler
    implements InternalMockHandler<Object> {
        private final Class<?> mock;

        public PowerMockInternalMockHandler(Class<?> mock) {
            this.mock = mock;
        }

        public MockCreationSettings getMockSettings() {
            MockSettingsImpl mockSettings = new MockSettingsImpl();
            mockSettings.setMockName((MockName)new MockNameImpl(this.mock.getName()));
            mockSettings.setTypeToMock(this.mock);
            return mockSettings;
        }

        public VoidMethodStubbable<Object> voidMethodStubbable(Object mock) {
            return null;
        }

        public void setAnswersForStubbing(List<Answer> answers) {
        }

        public InvocationContainer getInvocationContainer() {
            return null;
        }

        public Object handle(Invocation invocation) throws Throwable {
            return null;
        }
    }
}

