/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.core.classloader;

import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.net.URL;
import java.util.Enumeration;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.powermock.core.classloader.MockClassLoaderConfiguration;
import org.powermock.reflect.Whitebox;

abstract class DeferSupportingClassLoader
extends ClassLoader {
    private final ConcurrentMap<String, SoftReference<Class<?>>> classes;
    private final ConcurrentMap<String, Object> parallelLockMap;
    private final MockClassLoaderConfiguration configuration;
    ClassLoader deferTo;

    DeferSupportingClassLoader(ClassLoader classloader, MockClassLoaderConfiguration configuration) {
        this.configuration = configuration;
        this.classes = new ConcurrentHashMap();
        this.deferTo = classloader == null ? ClassLoader.getSystemClassLoader() : classloader;
        this.parallelLockMap = new ConcurrentHashMap<String, Object>();
    }

    @Override
    public URL getResource(String s) {
        return this.deferTo.getResource(s);
    }

    @Override
    public InputStream getResourceAsStream(String s) {
        return this.deferTo.getResourceAsStream(s);
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        if (this.deferTo.equals(this.getParent())) {
            return this.deferTo.getResources(name);
        }
        return super.getResources(name);
    }

    public MockClassLoaderConfiguration getConfiguration() {
        return this.configuration;
    }

    public void cache(Class<?> cls) {
        if (cls != null) {
            this.classes.put(cls.getName(), new SoftReference(cls));
        }
    }

    protected abstract Class<?> loadClassByThisClassLoader(String var1) throws ClassFormatError, ClassNotFoundException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Object object = this.getClassLoadingLock(name);
        synchronized (object) {
            Class<?> clazz = this.findLoadedClass1(name);
            if (clazz == null) {
                clazz = this.loadClass1(name, resolve);
            }
            return clazz;
        }
    }

    @Override
    protected Object getClassLoadingLock(String className) {
        Object newLock;
        Object lock = this;
        if (this.parallelLockMap != null && (lock = this.parallelLockMap.putIfAbsent(className, newLock = new Object())) == null) {
            lock = newLock;
        }
        return lock;
    }

    @Override
    protected URL findResource(String name) {
        try {
            return (URL)Whitebox.invokeMethod((Object)this.deferTo, (String)"findResource", (Object[])new Object[]{name});
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected Enumeration<URL> findResources(String name) throws IOException {
        try {
            return (Enumeration)Whitebox.invokeMethod((Object)this.deferTo, (String)"findResources", (Object[])new Object[]{name});
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Class<?> loadClass1(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> clazz = this.shouldDefer(name) ? this.loadByDeferClassLoader(name) : this.loadClassByThisClassLoader(name);
        if (resolve) {
            this.resolveClass(clazz);
        }
        this.classes.put(name, new SoftReference(clazz));
        return clazz;
    }

    private Class<?> loadByDeferClassLoader(String name) throws ClassNotFoundException {
        Class<?> clazz = this.deferTo.loadClass(name);
        return clazz;
    }

    private boolean shouldDefer(String name) {
        return this.configuration.shouldDefer(name);
    }

    private Class<?> findLoadedClass1(String name) {
        SoftReference reference = (SoftReference)this.classes.get(name);
        Class<?> clazz = null;
        if (reference != null) {
            clazz = (Class<?>)reference.get();
        }
        if (clazz == null) {
            clazz = this.findLoadedClass(name);
        }
        return clazz;
    }
}

