/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.modules.junit4.rule;

import org.junit.rules.MethodRule;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.Statement;
import org.powermock.classloading.ClassloaderExecutor;
import org.powermock.modules.junit4.rule.PowerMockClassloaderExecutor;
import org.powermock.modules.junit4.rule.PowerMockStatement;
import org.powermock.tests.utils.MockPolicyInitializer;
import org.powermock.tests.utils.impl.MockPolicyInitializerImpl;

public class PowerMockRule
implements MethodRule {
    private static ClassloaderExecutor classloaderExecutor;
    private static Class<?> previousTargetClass;
    private static MockPolicyInitializer mockPolicyInitializer;

    public Statement apply(Statement base, FrameworkMethod method, Object target) {
        if (classloaderExecutor == null || previousTargetClass != target.getClass()) {
            Class<?> testClass = target.getClass();
            mockPolicyInitializer = new MockPolicyInitializerImpl(testClass);
            classloaderExecutor = PowerMockClassloaderExecutor.forClass(testClass, mockPolicyInitializer);
            previousTargetClass = target.getClass();
        }
        return new PowerMockStatement(base, classloaderExecutor, mockPolicyInitializer);
    }
}

