/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.component.cookiepolicy;

import jakarta.el.ValueExpression;
import jakarta.faces.component.ActionSource;
import jakarta.faces.component.UIComponent;
import jakarta.faces.event.ActionListener;
import jakarta.faces.view.facelets.ComponentHandler;
import jakarta.faces.view.facelets.FaceletContext;
import jakarta.faces.view.facelets.TagAttribute;
import jakarta.faces.view.facelets.TagConfig;
import jakarta.faces.view.facelets.TagException;
import jakarta.faces.view.facelets.TagHandler;
import java.io.IOException;
import org.primefaces.extensions.component.cookiepolicy.CookiePolicySaveActionListener;

public class CookiePolicySaveTagHandler
extends TagHandler {
    private final TagAttribute policyAttribute = this.getRequiredAttribute("policy");
    private final TagAttribute retentionAttribute = this.getAttribute("retention");

    public CookiePolicySaveTagHandler(TagConfig config) {
        super(config);
    }

    public void apply(FaceletContext context, UIComponent parent) throws IOException {
        if (parent == null) {
            return;
        }
        if (!ComponentHandler.isNew((UIComponent)parent)) {
            return;
        }
        if (!(parent instanceof ActionSource)) {
            throw new TagException(this.tag, "Can only be attached to ActionSource components.");
        }
        ValueExpression policyValueExpression = this.policyAttribute.getValueExpression(context, String.class);
        ValueExpression retentionValueExpression = null != this.retentionAttribute ? this.retentionAttribute.getValueExpression(context, Integer.class) : null;
        ActionSource actionSource = (ActionSource)parent;
        actionSource.addActionListener((ActionListener)new CookiePolicySaveActionListener(policyValueExpression, retentionValueExpression));
    }
}

