/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.component.fuzzysearch;

import jakarta.faces.component.EditableValueHolder;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UIInput;
import jakarta.faces.component.UISelectOne;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import jakarta.faces.model.SelectItem;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.primefaces.extensions.component.fuzzysearch.FuzzySearch;
import org.primefaces.renderkit.SelectOneRenderer;
import org.primefaces.shaded.json.JSONArray;
import org.primefaces.shaded.json.JSONObject;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.HTML;
import org.primefaces.util.WidgetBuilder;

public class FuzzySearchRenderer
extends SelectOneRenderer {
    private static final String INPUT = "_input";

    public void decode(FacesContext context, UIComponent component) {
        FuzzySearch fuzzySearch = (FuzzySearch)component;
        if (!this.shouldDecode((UIInput)fuzzySearch)) {
            return;
        }
        String clientId = fuzzySearch.getClientId(context);
        Map params = context.getExternalContext().getRequestParameterMap();
        String submittedValue = (String)params.get(clientId + INPUT);
        if (submittedValue != null) {
            fuzzySearch.setSubmittedValue(submittedValue);
        }
        this.decodeBehaviors(context, (UIComponent)fuzzySearch);
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        FuzzySearch fuzzySearch = (FuzzySearch)component;
        this.encodeMarkup(context, fuzzySearch);
        this.encodeScript(context, fuzzySearch);
    }

    protected void encodeMarkup(FacesContext context, FuzzySearch fuzzySearch) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = fuzzySearch.getClientId(context);
        List selectItems = this.getSelectItems(context, (UIInput)fuzzySearch);
        int selectItemsSize = selectItems.size();
        String style = fuzzySearch.getStyle();
        String styleClass = this.getStyleClassBuilder(context).add("ui-fuzzysearch ui-widget ui-corner-all").add(fuzzySearch.getStyleClass()).add("ui-buttonset-" + selectItemsSize).add(!fuzzySearch.isValid(), "ui-state-error").build();
        writer.startElement("div", (UIComponent)fuzzySearch);
        writer.writeAttribute("id", (Object)clientId, "id");
        writer.writeAttribute("class", (Object)styleClass, "styleClass");
        if (style != null) {
            writer.writeAttribute("style", (Object)style, "style");
        }
        writer.startElement("input", (UIComponent)fuzzySearch);
        writer.writeAttribute("id", (Object)(clientId + INPUT), null);
        writer.writeAttribute("name", (Object)(clientId + INPUT), null);
        writer.writeAttribute("placeholder", (Object)fuzzySearch.getPlaceholder(), null);
        writer.writeAttribute("class", (Object)this.createStyleClass((UIInput)fuzzySearch, "ui-inputfield ui-inputtext ui-widget ui-state-default ui-corner-all"), "styleClass");
        this.renderPassThruAttributes(context, (UIComponent)fuzzySearch, HTML.TAB_INDEX);
        this.renderDomEvents(context, (UIComponent)fuzzySearch, HTML.BLUR_FOCUS_EVENTS);
        this.renderAccessibilityAttributes(context, (UIInput)fuzzySearch);
        this.renderValidationMetadata(context, (EditableValueHolder)fuzzySearch);
        String valueToRender = ComponentUtils.getValueToRender((FacesContext)context, (UIComponent)fuzzySearch);
        if (valueToRender != null) {
            writer.writeAttribute("value", (Object)valueToRender, null);
        }
        writer.endElement("input");
        writer.startElement("div", (UIComponent)fuzzySearch);
        writer.writeAttribute("id", (Object)(clientId + "_fuzzysearch-search-results"), null);
        if (fuzzySearch.isListItemsAtTheBeginning()) {
            this.encodeSelectItems(context, fuzzySearch, selectItems);
        }
        writer.endElement("div");
        writer.endElement("div");
    }

    protected void encodeSelectItems(FacesContext context, FuzzySearch fuzzySearch, List<SelectItem> selectItems) throws IOException {
        for (SelectItem selectItem : selectItems) {
            this.encodeOption(context, fuzzySearch, selectItem);
        }
    }

    protected void encodeOption(FacesContext context, FuzzySearch fuzzySearch, SelectItem option) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String itemValueAsString = this.getOptionAsString(context, (UIComponent)fuzzySearch, fuzzySearch.getConverter(), option.getValue());
        String resultStyle = fuzzySearch.getResultStyle();
        String resultStyleClass = this.getStyleClassBuilder(context).add("ui-fuzzysearch-item").add(fuzzySearch.getResultStyleClass()).build();
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)resultStyleClass, "resultStyleClass");
        if (resultStyle != null) {
            writer.writeAttribute("style", (Object)resultStyle, "resultStyle");
        }
        writer.writeAttribute("tabindex", (Object)fuzzySearch.getTabindex(), null);
        if (option.getDescription() != null) {
            writer.writeAttribute("title", (Object)option.getDescription(), null);
        }
        writer.writeAttribute("data-item-value", (Object)itemValueAsString, null);
        if (option.isEscape()) {
            writer.writeText((Object)option.getLabel(), "itemLabel");
        } else {
            writer.write(option.getLabel());
        }
        writer.endElement("div");
    }

    protected void encodeScript(FacesContext context, FuzzySearch fuzzySearch) throws IOException {
        WidgetBuilder wb = this.getWidgetBuilder(context);
        List selectItems = this.getSelectItems(context, (UIInput)fuzzySearch);
        JSONArray ja = new JSONArray();
        for (SelectItem selectItem : selectItems) {
            ja.put((Object)new JSONObject((Object)selectItem));
        }
        String jsonDatasource = ja.toString();
        wb.init(FuzzySearch.class.getSimpleName(), (UIComponent)fuzzySearch).attr("resultStyle", fuzzySearch.getResultStyle()).attr("resultStyleClass", fuzzySearch.getResultStyleClass()).attr("listItemsAtTheBeginning", Boolean.valueOf(fuzzySearch.isListItemsAtTheBeginning())).attr("datasource", jsonDatasource).attr("unselectable", fuzzySearch.isUnselectable(), true).attr("highlight", fuzzySearch.isHighlight(), true).callback("change", "function()", fuzzySearch.getOnchange());
        this.encodeClientBehaviors(context, fuzzySearch);
        wb.finish();
    }

    protected String getSubmitParam(FacesContext context, UISelectOne selectOne) {
        return selectOne.getClientId(context);
    }
}

