/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.component.masterdetail;

import jakarta.el.MethodExpression;
import jakarta.el.ValueExpression;
import jakarta.faces.FacesException;
import jakarta.faces.component.ActionSource;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.behavior.ClientBehavior;
import jakarta.faces.component.behavior.ClientBehaviorHolder;
import jakarta.faces.event.ActionListener;
import jakarta.faces.event.AjaxBehaviorListener;
import jakarta.faces.event.ComponentSystemEventListener;
import jakarta.faces.event.PreRenderComponentEvent;
import jakarta.faces.view.facelets.ComponentHandler;
import jakarta.faces.view.facelets.FaceletContext;
import jakarta.faces.view.facelets.TagAttribute;
import jakarta.faces.view.facelets.TagConfig;
import jakarta.faces.view.facelets.TagHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.primefaces.behavior.ajax.AjaxBehavior;
import org.primefaces.component.api.AjaxSource;
import org.primefaces.extensions.component.masterdetail.PreRenderSourceListener;
import org.primefaces.extensions.component.masterdetail.SelectDetailLevelListener;
import org.primefaces.extensions.util.ExtLangUtils;

public class SelectDetailLevelTagHandler
extends TagHandler {
    private final TagAttribute contextValue = this.getAttribute("contextValue");
    private final TagAttribute listener = this.getAttribute("listener");
    private final TagAttribute level = this.getAttribute("level");
    private final TagAttribute step = this.getAttribute("step");
    private final TagAttribute preserveInputs = this.getAttribute("preserveInputs");
    private final TagAttribute resetInputs = this.getAttribute("resetInputs");
    private final TagAttribute event = super.getAttribute("event");

    public SelectDetailLevelTagHandler(TagConfig config) {
        super(config);
    }

    public void apply(FaceletContext ctx, UIComponent parent) {
        ValueExpression resetInputsVE;
        ValueExpression preserveInputsVE;
        ValueExpression selectedStepVE;
        ValueExpression selectedLevelVE;
        ValueExpression contextValueVE;
        if (!SelectDetailLevelTagHandler.isAjaxifiedComponent(parent)) {
            throw new FacesException("SelectDetailLevel must be only placed inside an ajaxified component.");
        }
        if (!ComponentHandler.isNew((UIComponent)parent)) {
            return;
        }
        if (this.contextValue != null && (contextValueVE = this.contextValue.getValueExpression(ctx, Object.class)) != null) {
            parent.getAttributes().put("mdContextValueVE", contextValueVE);
        }
        if (this.level != null && (selectedLevelVE = this.level.getValueExpression(ctx, Integer.TYPE)) != null) {
            parent.getAttributes().put("selectedLevelVE", selectedLevelVE);
        }
        if (this.step != null && (selectedStepVE = this.step.getValueExpression(ctx, Integer.TYPE)) != null) {
            parent.getAttributes().put("selectedStepVE", selectedStepVE);
        }
        if (this.preserveInputs != null && (preserveInputsVE = this.preserveInputs.getValueExpression(ctx, String.class)) != null) {
            parent.getAttributes().put("preserveInputsVE", preserveInputsVE);
        }
        if (this.resetInputs != null && (resetInputsVE = this.resetInputs.getValueExpression(ctx, String.class)) != null) {
            parent.getAttributes().put("resetInputsVE", resetInputsVE);
        }
        parent.subscribeToEvent(PreRenderComponentEvent.class, (ComponentSystemEventListener)new PreRenderSourceListener());
        if (this.listener != null) {
            MethodExpression me = this.listener.getMethodExpression(ctx, Object.class, new Class[]{Object.class});
            if (parent instanceof ActionSource) {
                ((ActionSource)parent).addActionListener((ActionListener)new SelectDetailLevelListener(me));
            } else if (parent instanceof ClientBehaviorHolder) {
                Collection<List<ClientBehavior>> clientBehaviors = SelectDetailLevelTagHandler.getClientBehaviors(ctx, this.event, (ClientBehaviorHolder)parent);
                if (clientBehaviors == null || clientBehaviors.isEmpty()) {
                    return;
                }
                for (List<ClientBehavior> listBehaviors : clientBehaviors) {
                    for (ClientBehavior clientBehavior : listBehaviors) {
                        if (clientBehavior instanceof AjaxBehavior) {
                            ((AjaxBehavior)clientBehavior).addAjaxBehaviorListener((AjaxBehaviorListener)new SelectDetailLevelListener(me));
                            continue;
                        }
                        if (!(clientBehavior instanceof jakarta.faces.component.behavior.AjaxBehavior)) continue;
                        ((jakarta.faces.component.behavior.AjaxBehavior)clientBehavior).addAjaxBehaviorListener((AjaxBehaviorListener)new SelectDetailLevelListener(me));
                    }
                }
            }
        }
    }

    public static boolean isAjaxifiedComponent(UIComponent component) {
        Collection behaviors;
        if (component instanceof AjaxSource && ((AjaxSource)component).isAjaxified()) {
            return true;
        }
        if (component instanceof ClientBehaviorHolder && !(behaviors = ((ClientBehaviorHolder)component).getClientBehaviors().values()).isEmpty()) {
            for (List listBehaviors : behaviors) {
                for (ClientBehavior clientBehavior : listBehaviors) {
                    if (!(clientBehavior instanceof jakarta.faces.component.behavior.AjaxBehavior) && !(clientBehavior instanceof AjaxBehavior)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static Collection<List<ClientBehavior>> getClientBehaviors(FaceletContext context, TagAttribute event, ClientBehaviorHolder clientBehaviorHolder) {
        String[] arrEvents;
        Map mapBehaviors = clientBehaviorHolder.getClientBehaviors();
        if (mapBehaviors == null || mapBehaviors.isEmpty()) {
            return Collections.emptyList();
        }
        String events = event != null ? event.getValue(context) : null;
        String[] stringArray = arrEvents = events != null ? events.split("[\\s,]+") : null;
        if (arrEvents == null || arrEvents.length < 1) {
            return mapBehaviors.values();
        }
        ArrayList<List<ClientBehavior>> behaviors = new ArrayList<List<ClientBehavior>>();
        for (Map.Entry entry : mapBehaviors.entrySet()) {
            if (!ExtLangUtils.contains(arrEvents, (String)entry.getKey())) continue;
            behaviors.add((List)entry.getValue());
        }
        return behaviors;
    }
}

