/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.application;

import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UIViewRoot;
import jakarta.faces.component.html.HtmlBody;
import jakarta.faces.component.html.HtmlOutputText;
import jakarta.faces.context.FacesContext;
import jakarta.faces.event.AbortProcessingException;
import jakarta.faces.event.SystemEvent;
import jakarta.faces.event.SystemEventListener;
import org.primefaces.component.outputlabel.OutputLabel;
import org.primefaces.extensions.util.HtmlSanitizer;

public class EscapeSanitizerComponentListener
implements SystemEventListener {
    private static final String PASS_THROUGH_SANITIZED = "sanitized";

    public void processEvent(SystemEvent event) throws AbortProcessingException {
        FacesContext context = event.getFacesContext();
        UIViewRoot root = context.getViewRoot();
        this.checkComponents((UIComponent)root);
    }

    public boolean isListenerForSource(Object source) {
        return source instanceof HtmlBody;
    }

    private void checkComponents(UIComponent component) {
        OutputLabel outputLabel;
        if (component == null) {
            return;
        }
        boolean shouldSanitize = false;
        String value = null;
        if (component instanceof HtmlOutputText) {
            HtmlOutputText htmlOutputText = (HtmlOutputText)component;
            if (!htmlOutputText.isEscape() && this.isNotAlreadySanitized(component)) {
                value = this.getValueAsString((UIComponent)htmlOutputText);
                shouldSanitize = value != null;
            }
        } else if (component instanceof OutputLabel && !(outputLabel = (OutputLabel)component).isEscape() && this.isNotAlreadySanitized(component)) {
            value = this.getValueAsString((UIComponent)outputLabel);
            boolean bl = shouldSanitize = value != null;
        }
        if (shouldSanitize) {
            component.getAttributes().put("value", this.sanitizeHtml(value));
        }
        for (UIComponent child : component.getChildren()) {
            this.checkComponents(child);
        }
        for (UIComponent facet : component.getFacets().values()) {
            this.checkComponents(facet);
        }
    }

    private String sanitizeHtml(String html) {
        return HtmlSanitizer.sanitizeHtml(html, true, true, true, true, false, false, false);
    }

    private String getValueAsString(UIComponent component) {
        Object value = component.getAttributes().get("value");
        return value instanceof String ? (String)value : null;
    }

    private boolean isNotAlreadySanitized(UIComponent component) {
        return !"true".equals(component.getPassThroughAttributes().get(PASS_THROUGH_SANITIZED));
    }
}

