/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.application;

import jakarta.faces.application.Resource;
import jakarta.faces.application.ResourceWrapper;
import jakarta.faces.context.ExternalContext;
import jakarta.faces.context.FacesContext;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.primefaces.util.LangUtils;

public class ThemeModificationResource
extends ResourceWrapper {
    public static final String RESPONSIVE_BREAKPOINT = "primefaces.RESPONSIVE_BREAKPOINT";
    private static final Map<String, String> CACHE = new HashMap<String, String>();
    private static final Map<String, List<String>> ACCENT_COLORS = new HashMap<String, List<String>>();
    private final String charEncoding;
    private final String responsiveBreakpoint;

    public ThemeModificationResource(Resource wrapped) {
        super(wrapped);
        ExternalContext externalContext = FacesContext.getCurrentInstance().getExternalContext();
        String encoding = externalContext.getRequestCharacterEncoding();
        if (LangUtils.isBlank((String)encoding)) {
            encoding = StandardCharsets.UTF_8.name();
        }
        this.charEncoding = encoding;
        String breakpoint = externalContext.getInitParameter(RESPONSIVE_BREAKPOINT);
        this.responsiveBreakpoint = Objects.toString(breakpoint, "640");
    }

    public InputStream getInputStream() throws IOException {
        String library = this.getWrapped().getLibraryName();
        List<String> accentColors = ACCENT_COLORS.get(library);
        if (accentColors == null || accentColors.isEmpty()) {
            return this.getWrapped().getInputStream();
        }
        if (CACHE.containsKey(library)) {
            return new ByteArrayInputStream(CACHE.get(library).getBytes(this.charEncoding));
        }
        String css = this.filterCss(library, accentColors);
        CACHE.put(library, css);
        return new ByteArrayInputStream(css.getBytes(this.charEncoding));
    }

    protected String filterCss(String library, List<String> accentColors) throws IOException {
        String accentColor = "var(--" + library.replace("primefaces-", "") + "%d)";
        String css = this.getContent();
        for (int i = 0; i < accentColors.size(); ++i) {
            css = css.replace(accentColors.get(i), String.format(accentColor, i));
        }
        css = css.replaceAll("@media\\s*\\((min|max)-width:\\s*\\d+px\\)", "@media($1-width: " + this.responsiveBreakpoint + "px)");
        return css;
    }

    protected String getContent() throws IOException {
        try (InputStream inputStream = this.getWrapped().getInputStream();){
            String string = new String(inputStream.readAllBytes(), this.charEncoding);
            return string;
        }
    }

    static {
        ACCENT_COLORS.put("primefaces-arya", Arrays.asList("#90CAF9", "rgba(255,255,255,.87)", "rgb(106.7153846154,184.1974358974,246.9846153846)", "rgb(177.3, 217.9, 250.8)", "#212529"));
        ACCENT_COLORS.put("primefaces-arya-blue", Arrays.asList("#90CAF9", "rgba(255,255,255,.87)", "rgb(106.7153846154,184.1974358974,246.9846153846)", "rgb(177.3, 217.9, 250.8)", "#212529"));
        ACCENT_COLORS.put("primefaces-saga", Arrays.asList("#2196f3", "#e9ecef", "#0b7ad1", "rgb(166.2, 213, 250.2)", "#495057"));
        ACCENT_COLORS.put("primefaces-saga-blue", Arrays.asList("#2196f3", "#e9ecef", "#0b7ad1", "rgb(166.2, 213, 250.2)", "#495057"));
        ACCENT_COLORS.put("primefaces-vela", Arrays.asList("#90CAF9", "#6bb8f7", "#45a6f5", "rgb(177.3, 217.9, 250.8)", "#212529"));
        ACCENT_COLORS.put("primefaces-vela-blue", Arrays.asList("#90caf9", "rgba(255,255,255,.03)", "#45a6f5", "rgb(177.3, 217.9, 250.8)", "#212529"));
    }
}

