/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.component.codescanner;

import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import java.io.IOException;
import org.primefaces.component.api.InputHolder;
import org.primefaces.expression.SearchExpressionUtils;
import org.primefaces.extensions.component.codescanner.CodeScanner;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.WidgetBuilder;

public class CodeScannerRenderer
extends CoreRenderer {
    public void decode(FacesContext context, UIComponent component) {
        this.decodeBehaviors(context, component);
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        CodeScanner codeScanner = (CodeScanner)component;
        this.encodeMarkup(context, codeScanner);
        this.encodeScript(context, codeScanner);
    }

    protected void encodeMarkup(FacesContext context, CodeScanner codeScanner) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = codeScanner.getClientId(context);
        String styleClass = this.getStyleClassBuilder(context).add("ui-codescanner ui-widget").add(codeScanner.getStyleClass()).build();
        writer.startElement("span", (UIComponent)codeScanner);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.writeAttribute("class", (Object)styleClass, "styleClass");
        if (codeScanner.getStyle() != null) {
            writer.writeAttribute("style", (Object)codeScanner.getStyle(), "style");
        }
        if (codeScanner.isVideo()) {
            this.encodeVideo(context, codeScanner);
        }
        writer.endElement("span");
    }

    protected void encodeVideo(FacesContext context, CodeScanner codeScanner) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("video", null);
        if (codeScanner.getWidth() != null) {
            writer.writeAttribute("width", (Object)codeScanner.getWidth(), null);
        }
        if (codeScanner.getHeight() != null) {
            writer.writeAttribute("height", (Object)codeScanner.getHeight(), null);
        }
        writer.endElement("video");
    }

    protected void encodeScript(FacesContext context, CodeScanner codeScanner) throws IOException {
        String forInputClientId;
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.init("ExtCodeScanner", (UIComponent)codeScanner).attr("type", codeScanner.getTypeEnum().name()).attr("autoStart", Boolean.valueOf(codeScanner.isAutoStart()));
        if (codeScanner.getDeviceId() != null) {
            wb.attr("deviceId", codeScanner.getDeviceId());
        }
        if (codeScanner.getFor() != null && (forInputClientId = this.getForInputClientId(context, codeScanner)) != null) {
            wb.attr("forInput", forInputClientId);
        }
        if (codeScanner.getOnsuccess() != null) {
            wb.callback("onsuccess", "function()", codeScanner.getOnsuccess());
        }
        if (codeScanner.getOnerror() != null) {
            wb.callback("onerror", "function()", codeScanner.getOnerror());
        }
        this.encodeClientBehaviors(context, codeScanner);
        wb.finish();
    }

    protected String getForInputClientId(FacesContext context, CodeScanner codeScanner) {
        UIComponent forComponent = SearchExpressionUtils.resolveComponent((String)codeScanner.getFor(), (UIComponent)codeScanner);
        if (forComponent == null) {
            return null;
        }
        if (forComponent instanceof InputHolder) {
            return ((InputHolder)forComponent).getInputClientId();
        }
        return forComponent.getClientId(context);
    }
}

