/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.component.echarts;

import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import java.io.IOException;
import java.io.Writer;
import org.primefaces.extensions.component.echarts.EChart;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.FacetUtils;
import org.primefaces.util.FastStringWriter;
import org.primefaces.util.WidgetBuilder;

public class EChartRenderer
extends CoreRenderer {
    public void decode(FacesContext context, UIComponent component) {
        super.decodeBehaviors(context, component);
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        EChart chart = (EChart)component;
        this.encodeMarkup(context, chart);
        this.encodeScript(context, chart);
    }

    protected void encodeMarkup(FacesContext context, EChart chart) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = chart.getClientId(context);
        String style = chart.getStyle();
        String styleClass = this.getStyleClassBuilder(context).add("ui-chart").add(chart.getStyleClass()).build();
        writer.startElement("div", null);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.writeAttribute("class", (Object)styleClass, "styleClass");
        if (style != null) {
            writer.writeAttribute("style", (Object)style, "style");
        } else {
            writer.writeAttribute("style", (Object)"width: 600px; height: 400px;", "style");
        }
        writer.endElement("div");
    }

    protected void encodeScript(FacesContext context, EChart chart) throws IOException {
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.init("ExtEChart", (UIComponent)chart).attr("theme", chart.getTheme(), "default").nativeAttr("config", this.renderConfig(context, chart)).nativeAttr("extender", chart.getExtender());
        this.encodeClientBehaviors(context, chart);
        wb.finish();
    }

    protected String renderConfig(FacesContext context, EChart chart) throws IOException {
        UIComponent facet = chart.getFacet("value");
        if (FacetUtils.shouldRenderFacet((UIComponent)facet)) {
            ResponseWriter originalWriter = context.getResponseWriter();
            FastStringWriter fsw = new FastStringWriter();
            ResponseWriter clonedWriter = originalWriter.cloneWithWriter((Writer)fsw);
            context.setResponseWriter(clonedWriter);
            facet.encodeAll(context);
            context.setResponseWriter(originalWriter);
            return fsw.toString();
        }
        return chart.getValue();
    }
}

