/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.util;

import java.util.regex.Pattern;
import org.owasp.html.HtmlPolicyBuilder;
import org.owasp.html.PolicyFactory;
import org.owasp.html.Sanitizers;
import org.primefaces.util.LangUtils;

public class HtmlSanitizer {
    private static final PolicyFactory HTML_IMAGES_SANITIZER = new HtmlPolicyBuilder().allowUrlProtocols(new String[]{"data", "http", "https"}).allowElements(new String[]{"img", "figure"}).allowAttributes(new String[]{"src"}).matching(Pattern.compile("^(?!javascript:|ftp:|file:|blob:|mailto:).*", 2)).onElements(new String[]{"img"}).allowAttributes(new String[]{"data-rotate", "data-proportion", "data-rotatex", "data-rotatey", "data-size", "data-align", "data-percentage", "data-index", "data-file-name", "data-file-size", "data-origin"}).onElements(new String[]{"img"}).allowAttributes(new String[]{"id", "style"}).onElements(new String[]{"img", "figure"}).toFactory();
    private static final PolicyFactory HTML_MEDIA_SANITIZER = new HtmlPolicyBuilder().allowUrlProtocols(new String[]{"data", "http", "https"}).allowElements(new String[]{"video", "audio", "source", "iframe", "figure"}).allowAttributes(new String[]{"id", "controls", "width", "height", "origin-size", "src", "allowfullscreen", "class", "style", "data-proportion", "data-align", "data-percentage", " data-size", "data-file-name", "data-file-size", "data-origin", "data-rotate", "data-index"}).onElements(new String[]{"video", "audio", "source", "iframe", "figure"}).toFactory();
    private static final PolicyFactory HTML_LINKS_SANITIZER = Sanitizers.LINKS.and(new HtmlPolicyBuilder().allowElements(new String[]{"a"}).allowAttributes(new String[]{"id", "target", "style", "class"}).onElements(new String[]{"a"}).toFactory());
    private static final PolicyFactory HTML_STYLES_SANITIZER = Sanitizers.STYLES.and(new HtmlPolicyBuilder().allowElements(new String[]{"table", "span", "li", "p", "pre", "div", "hr"}).allowAttributes(new String[]{"id", "class", "style", "contenteditable"}).onElements(new String[]{"table", "span", "li", "p", "pre", "div", "hr"}).toFactory());
    private static final PolicyFactory HTML_DENY_ALL_SANITIZER = new HtmlPolicyBuilder().toFactory();

    private HtmlSanitizer() {
    }

    public static PolicyFactory creatPolicyFactory(boolean allowBlocks, boolean allowFormatting, boolean allowLinks, boolean allowStyles, boolean allowImages, boolean allowTables, boolean allowMedia) {
        PolicyFactory sanitizer = HTML_DENY_ALL_SANITIZER;
        if (allowBlocks) {
            sanitizer = sanitizer.and(Sanitizers.BLOCKS);
        }
        if (allowFormatting) {
            sanitizer = sanitizer.and(Sanitizers.FORMATTING);
        }
        if (allowLinks) {
            sanitizer = sanitizer.and(HTML_LINKS_SANITIZER);
        }
        if (allowStyles) {
            sanitizer = sanitizer.and(HTML_STYLES_SANITIZER);
        }
        if (allowImages) {
            sanitizer = sanitizer.and(HTML_IMAGES_SANITIZER);
        }
        if (allowMedia) {
            sanitizer = sanitizer.and(HTML_MEDIA_SANITIZER);
        }
        if (allowTables) {
            sanitizer = sanitizer.and(Sanitizers.TABLES);
        }
        return sanitizer;
    }

    public static String sanitizeHtml(String value, boolean allowBlocks, boolean allowFormatting, boolean allowLinks, boolean allowStyles, boolean allowImages, boolean allowTables, boolean allowMedia) {
        if (LangUtils.isBlank((String)value)) {
            return value;
        }
        PolicyFactory sanitizer = HtmlSanitizer.creatPolicyFactory(allowBlocks, allowFormatting, allowLinks, allowStyles, allowImages, allowTables, allowMedia);
        return sanitizer.sanitize(value);
    }
}

