/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.component.gravatar;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.commons.lang3.StringUtils;
import org.primefaces.extensions.component.gravatar.Gravatar;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.LangUtils;

public class GravatarRenderer
extends CoreRenderer {
    private static final String BASE_URL = "www.gravatar.com";

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        this.encodeMarkup(context, (Gravatar)component);
    }

    private void encodeMarkup(FacesContext context, Gravatar gravatar) throws IOException {
        String url;
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("img", (UIComponent)gravatar);
        writer.writeAttribute("id", (Object)gravatar.getClientId(), null);
        writer.writeAttribute("style", (Object)gravatar.getStyle(), null);
        try {
            url = this.generateURL(gravatar);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        writer.writeAttribute("src", (Object)url, null);
        writer.endElement("img");
    }

    private String generateURL(Gravatar gravatar) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        boolean qrCode = gravatar.isQrCode();
        Integer size = gravatar.getSize();
        String notFound = gravatar.getNotFound();
        String url = gravatar.isSecure() ? "https://www.gravatar.com/" : "http://www.gravatar.com/";
        if (!qrCode) {
            url = url + "avatar/";
        }
        url = url + this.generateMailHash(gravatar);
        url = url + (qrCode ? ".qr" : ".jpg");
        ArrayList<String> params = new ArrayList<String>();
        if (size != null) {
            params.add("s=" + size);
        }
        if (!LangUtils.isValueBlank((String)notFound) && !notFound.equals("default") && Gravatar.NOT_FOUND_VALUES.contains(notFound)) {
            params.add("d=" + notFound);
        }
        if (params.size() > 0) {
            url = url + "?" + StringUtils.join(params, (String)"&");
        }
        return url;
    }

    private String generateMailHash(Gravatar gravatar) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        MessageDigest md = MessageDigest.getInstance("MD5");
        md.update(String.valueOf(gravatar.getValue()).getBytes("UTF-8"));
        byte[] digest = md.digest();
        StringBuffer sb = new StringBuffer();
        for (byte b : digest) {
            sb.append(String.format("%02x", b & 0xFF));
        }
        return sb.toString();
    }
}

