/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.component.orgchart;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import javax.faces.application.ResourceDependencies;
import javax.faces.application.ResourceDependency;
import javax.faces.component.UIComponent;
import javax.faces.component.UIData;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.context.FacesContext;
import javax.faces.event.AjaxBehaviorEvent;
import javax.faces.event.FacesEvent;
import org.primefaces.component.api.Widget;
import org.primefaces.extensions.event.OrgChartClickEvent;
import org.primefaces.extensions.event.OrgChartDropEvent;

@ResourceDependencies(value={@ResourceDependency(library="primefaces", name="jquery/jquery.js"), @ResourceDependency(library="primefaces", name="jquery/jquery-plugins.js"), @ResourceDependency(library="primefaces", name="core.js"), @ResourceDependency(library="primefaces-extensions", name="primefaces-extensions.js"), @ResourceDependency(library="primefaces-extensions", name="orgchart/orgchart.js"), @ResourceDependency(library="primefaces-extensions", name="orgchart/orgchart.css")})
public class OrgChart
extends UIData
implements Widget,
ClientBehaviorHolder {
    public static final String STYLE_CLASS = "ui-orgchart ";
    public static final String COMPONENT_TYPE = "org.primefaces.extensions.component.OrgChart";
    public static final String COMPONENT_FAMILY = "org.primefaces.extensions.component";
    private static final String DEFAULT_RENDERER = "org.primefaces.extensions.component.orgchart.OrgChartRenderer";
    private static final Collection<String> EVENT_NAMES = Collections.unmodifiableCollection(Arrays.asList("click", "drop"));

    public OrgChart() {
        this.setRendererType(DEFAULT_RENDERER);
    }

    public String getFamily() {
        return COMPONENT_FAMILY;
    }

    public Collection<String> getEventNames() {
        return EVENT_NAMES;
    }

    public String getDefaultEventName() {
        return "click";
    }

    public void processDecodes(FacesContext fc) {
        if (this.isSelfRequest(fc)) {
            this.decode(fc);
        } else {
            super.processDecodes(fc);
        }
    }

    public void queueEvent(FacesEvent event) {
        FacesContext fc = FacesContext.getCurrentInstance();
        if (this.isSelfRequest(fc) && event instanceof AjaxBehaviorEvent) {
            Map params = fc.getExternalContext().getRequestParameterMap();
            String eventName = (String)params.get("javax.faces.behavior.event");
            AjaxBehaviorEvent behaviorEvent = (AjaxBehaviorEvent)event;
            String clientId = this.getClientId(fc);
            if ("click".equals(eventName)) {
                String id = (String)params.get(clientId + "_nodeId");
                String hierarchyStr = (String)params.get(clientId + "_hierarchy");
                OrgChartClickEvent orgChartClickEvent = new OrgChartClickEvent((UIComponent)this, behaviorEvent.getBehavior(), id, hierarchyStr);
                orgChartClickEvent.setPhaseId(event.getPhaseId());
                super.queueEvent((FacesEvent)orgChartClickEvent);
            } else if ("drop".equals(eventName)) {
                String hierarchyStr = (String)params.get(clientId + "_hierarchy");
                String draggedNodeId = (String)params.get(clientId + "_draggedNodeId");
                String droppedZoneId = (String)params.get(clientId + "_droppedZoneId");
                OrgChartDropEvent orgChartDropEvent = new OrgChartDropEvent((UIComponent)this, behaviorEvent.getBehavior(), hierarchyStr, draggedNodeId, droppedZoneId);
                orgChartDropEvent.setPhaseId(event.getPhaseId());
                super.queueEvent((FacesEvent)orgChartDropEvent);
            }
        }
    }

    private boolean isSelfRequest(FacesContext context) {
        return this.getClientId(context).equals(context.getExternalContext().getRequestParameterMap().get("javax.faces.source"));
    }

    public String getNodeId() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.nodeId), (Object)"id");
    }

    public void setNodeId(String _nodeId) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.nodeId), (Object)_nodeId);
    }

    public String getWidgetVar() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.widgetVar), null);
    }

    public void setWidgetVar(String _widgetVar) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.widgetVar), (Object)_widgetVar);
    }

    public String getNodeContent() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.nodeContent), (Object)"title");
    }

    public void setNodeContent(String _nodeContent) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.nodeContent), (Object)_nodeContent);
    }

    public String getDirection() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.direction), (Object)"t2b");
    }

    public void setDirection(String _direction) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.direction), (Object)_direction);
    }

    public Boolean getPan() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.pan), (Object)false);
    }

    public void setPan(Boolean _pan) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.pan), (Object)_pan);
    }

    public Boolean getToggleSiblingsResp() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.toggleSiblingsResp), (Object)false);
    }

    public void setToggleSiblingsResp(Boolean _toggleSiblingsResp) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.toggleSiblingsResp), (Object)_toggleSiblingsResp);
    }

    public Integer getDepth() {
        return (Integer)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.depth), (Object)999);
    }

    public void setDepth(Integer _depth) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.depth), (Object)_depth);
    }

    public Boolean getExportButton() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.exportButton), (Object)false);
    }

    public void setExportButton(Boolean _exportButton) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.exportButton), (Object)_exportButton);
    }

    public String getExportFilename() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.exportFilename), (Object)"OrgChart");
    }

    public void setExportFilename(String _exportFilename) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.exportFilename), (Object)_exportFilename);
    }

    public String getExportFileextension() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.exportFileextension), (Object)"png");
    }

    public void setExportFileextension(String _exportFileextension) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.exportFileextension), (Object)_exportFileextension);
    }

    public String getParentNodeSymbol() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.parentNodeSymbol), (Object)"fa-users");
    }

    public void setParentNodeSymbol(String _parentNodeSymbol) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.parentNodeSymbol), (Object)_parentNodeSymbol);
    }

    public Boolean getDraggable() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.draggable), (Object)false);
    }

    public void setDraggable(Boolean _draggable) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.draggable), (Object)_draggable);
    }

    public String getChartClass() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.chartClass), (Object)"");
    }

    public void setChartClass(String _chartClass) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.chartClass), (Object)_chartClass);
    }

    public Boolean getZoom() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.zoom), (Object)false);
    }

    public void setZoom(Boolean _zoom) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.zoom), (Object)_zoom);
    }

    public Number getZoominLimit() {
        return (Number)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.zoominLimit), (Object)7);
    }

    public void setZoominLimit(Number _zoominLimit) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.zoominLimit), (Object)_zoominLimit);
    }

    public Number getZoomoutLimit() {
        return (Number)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.zoomoutLimit), (Object)0.5);
    }

    public void setZoomoutLimit(Number _zoomoutLimit) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.zoomoutLimit), (Object)_zoomoutLimit);
    }

    public Integer getVerticalDepth() {
        return (Integer)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.verticalDepth), null);
    }

    public void setVerticalDepth(Integer _verticalDepth) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.verticalDepth), (Object)_verticalDepth);
    }

    public String getNodeTitle() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.nodeTitle), (Object)"name");
    }

    public void setNodeTitle(String _nodeTitle) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.nodeTitle), (Object)_nodeTitle);
    }

    public String getStyle() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.style), null);
    }

    public void setStyle(String _style) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.style), (Object)_style);
    }

    public String getStyleClass() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.styleClass), null);
    }

    public void setStyleClass(String _styleClass) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.styleClass), (Object)_styleClass);
    }

    public String getExtender() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.extender), null);
    }

    public void setExtender(String _extender) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.extender), (Object)_extender);
    }

    protected static enum PropertyKeys {
        nodeId,
        widgetVar,
        nodeContent,
        direction,
        pan,
        toggleSiblingsResp,
        depth,
        exportButton,
        exportFilename,
        exportFileextension,
        parentNodeSymbol,
        draggable,
        chartClass,
        zoom,
        zoominLimit,
        zoomoutLimit,
        verticalDepth,
        nodeTitle,
        style,
        styleClass,
        extender;

        private String toString;

        private PropertyKeys(String toString) {
            this.toString = toString;
        }

        private PropertyKeys() {
        }

        public String toString() {
            return this.toString != null ? this.toString : super.toString();
        }
    }
}

