/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.model.dynaform;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.primefaces.extensions.model.common.KeyData;
import org.primefaces.extensions.model.dynaform.AbstractDynaFormElement;

public class DynaFormControl
extends AbstractDynaFormElement
implements KeyData {
    public static final String DEFAULT_TYPE = "default";
    private static final long serialVersionUID = 1L;
    private static final String KEY_PREFIX_ROW = "r";
    private static final String KEY_PREFIX_COLUMN = "c";
    private static final String KEY_SUFFIX_REGULAR = "reg";
    private static final String KEY_SUFFIX_EXTENDED = "ext";
    private static final String KEY_SUFFIX_POSITION = "p";
    private String key;
    private Object data;
    private final String type;
    private int position;

    public DynaFormControl(Object data, String type, int colspan, int rowspan, int row, int column, int position, boolean extended) {
        super(colspan, rowspan, row, column, extended);
        this.position = position;
        this.data = data;
        this.type = type != null ? type : DEFAULT_TYPE;
        this.generateKey();
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public void setKey(String key) {
        this.key = key;
    }

    @Override
    public Object getData() {
        return this.data;
    }

    @Override
    public void setData(Object data) {
        this.data = data;
    }

    public String getType() {
        return this.type;
    }

    public int getPosition() {
        return this.position;
    }

    void setPosition(int position) {
        this.position = position;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.position;
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        DynaFormControl that = (DynaFormControl)o;
        return this.position == that.position;
    }

    void generateKey() {
        StringBuilder sb = new StringBuilder();
        sb.append(KEY_PREFIX_ROW).append(this.getRow()).append(KEY_PREFIX_COLUMN).append(this.getColumn()).append(KEY_SUFFIX_POSITION).append(this.getPosition());
        if (this.isExtended()) {
            sb.append(KEY_SUFFIX_EXTENDED);
        } else {
            sb.append(KEY_SUFFIX_REGULAR);
        }
        this.setKey(sb.toString());
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("key", (Object)this.key).append("data", this.data).append("type", (Object)this.type).append("colspan", this.getColspan()).append("rowspan", this.getRowspan()).append("row", this.getRow()).append("column", this.getColumn()).append("extended", this.isExtended()).append("position", this.getPosition()).toString();
    }
}

