/*
 * Decompiled with CFR 0.152.
 */
package lombok.javac.handlers;

import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.JCDiagnostic;
import lombok.AccessLevel;
import lombok.core.AST;
import lombok.core.AnnotationValues;
import lombok.core.HandlerPriority;
import lombok.experimental.FieldDefaults;
import lombok.experimental.NonFinal;
import lombok.experimental.PackagePrivate;
import lombok.javac.JavacAnnotationHandler;
import lombok.javac.JavacNode;
import lombok.javac.handlers.JavacHandlerUtil;

@HandlerPriority(value=-512)
public class HandleFieldDefaults
extends JavacAnnotationHandler<FieldDefaults> {
    public boolean generateFieldDefaultsForType(JavacNode typeNode, JavacNode errorNode, AccessLevel level, boolean makeFinal, boolean checkForTypeLevelFieldDefaults) {
        boolean notAClass;
        if (checkForTypeLevelFieldDefaults && JavacHandlerUtil.hasAnnotation(FieldDefaults.class, typeNode)) {
            return true;
        }
        JCTree.JCClassDecl typeDecl = null;
        if (typeNode.get() instanceof JCTree.JCClassDecl) {
            typeDecl = (JCTree.JCClassDecl)typeNode.get();
        }
        long modifiers = typeDecl == null ? 0L : typeDecl.mods.flags;
        boolean bl = notAClass = (modifiers & 0x2200L) != 0L;
        if (typeDecl == null || notAClass) {
            errorNode.addError("@FieldDefaults is only supported on a class or an enum.");
            return false;
        }
        for (JavacNode field : typeNode.down()) {
            if (field.getKind() != AST.Kind.FIELD) continue;
            JCTree.JCVariableDecl fieldDecl = (JCTree.JCVariableDecl)field.get();
            if (fieldDecl.name.toString().startsWith("$")) continue;
            this.setFieldDefaultsForField(field, (JCDiagnostic.DiagnosticPosition)errorNode.get(), level, makeFinal);
        }
        return true;
    }

    public void setFieldDefaultsForField(JavacNode fieldNode, JCDiagnostic.DiagnosticPosition pos, AccessLevel level, boolean makeFinal) {
        JCTree.JCVariableDecl field = (JCTree.JCVariableDecl)fieldNode.get();
        if (level != null && level != AccessLevel.NONE && (field.mods.flags & 7L) == 0L && !JavacHandlerUtil.hasAnnotationAndDeleteIfNeccessary(PackagePrivate.class, fieldNode)) {
            field.mods.flags |= (long)JavacHandlerUtil.toJavacModifier(level);
        }
        if (makeFinal && (field.mods.flags & 0x10L) == 0L && !JavacHandlerUtil.hasAnnotationAndDeleteIfNeccessary(NonFinal.class, fieldNode)) {
            field.mods.flags |= 0x10L;
        }
        fieldNode.rebuild();
    }

    @Override
    public void handle(AnnotationValues<FieldDefaults> annotation, JCTree.JCAnnotation ast, JavacNode annotationNode) {
        JavacHandlerUtil.deleteAnnotationIfNeccessary(annotationNode, FieldDefaults.class);
        JavacHandlerUtil.deleteImportFromCompilationUnit(annotationNode, "lombok.AccessLevel");
        JavacNode node = (JavacNode)annotationNode.up();
        FieldDefaults instance = annotation.getInstance();
        AccessLevel level = instance.level();
        boolean makeFinal = instance.makeFinal();
        if (level == AccessLevel.NONE && !makeFinal) {
            annotationNode.addError("This does nothing; provide either level or makeFinal or both.");
            return;
        }
        if (node == null) {
            return;
        }
        this.generateFieldDefaultsForType(node, annotationNode, level, makeFinal, false);
    }
}

