/*
 * Decompiled with CFR 0.152.
 */
package lombok.javac.handlers;

import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Name;
import java.util.Collection;
import lombok.AccessLevel;
import lombok.core.AST;
import lombok.core.AnnotationValues;
import lombok.core.TransformationsUtil;
import lombok.experimental.Wither;
import lombok.javac.Javac;
import lombok.javac.JavacAnnotationHandler;
import lombok.javac.JavacNode;
import lombok.javac.handlers.JavacHandlerUtil;

public class HandleWither
extends JavacAnnotationHandler<Wither> {
    public void generateWitherForType(JavacNode typeNode, JavacNode errorNode, AccessLevel level, boolean checkForTypeLevelWither) {
        boolean notAClass;
        if (checkForTypeLevelWither && JavacHandlerUtil.hasAnnotation(Wither.class, typeNode)) {
            return;
        }
        JCTree.JCClassDecl typeDecl = null;
        if (typeNode.get() instanceof JCTree.JCClassDecl) {
            typeDecl = (JCTree.JCClassDecl)typeNode.get();
        }
        long modifiers = typeDecl == null ? 0L : typeDecl.mods.flags;
        boolean bl = notAClass = (modifiers & 0x6200L) != 0L;
        if (typeDecl == null || notAClass) {
            errorNode.addError("@Wither is only supported on a class or a field.");
            return;
        }
        for (JavacNode field : typeNode.down()) {
            if (field.getKind() != AST.Kind.FIELD) continue;
            JCTree.JCVariableDecl fieldDecl = (JCTree.JCVariableDecl)field.get();
            if (fieldDecl.name.toString().startsWith("$") || (fieldDecl.mods.flags & 8L) != 0L || (fieldDecl.mods.flags & 0x10L) != 0L && fieldDecl.init != null) continue;
            this.generateWitherForField(field, (JCDiagnostic.DiagnosticPosition)errorNode.get(), level);
        }
    }

    public void generateWitherForField(JavacNode fieldNode, JCDiagnostic.DiagnosticPosition pos, AccessLevel level) {
        for (JavacNode child : fieldNode.down()) {
            if (child.getKind() != AST.Kind.ANNOTATION || !JavacHandlerUtil.annotationTypeMatches(Wither.class, child)) continue;
            return;
        }
        this.createWitherForField(level, fieldNode, fieldNode, false);
    }

    @Override
    public void handle(AnnotationValues<Wither> annotation, JCTree.JCAnnotation ast, JavacNode annotationNode) {
        Collection<JavacNode> fields = annotationNode.upFromAnnotationToFields();
        JavacHandlerUtil.deleteAnnotationIfNeccessary(annotationNode, Wither.class);
        JavacHandlerUtil.deleteImportFromCompilationUnit(annotationNode, "lombok.AccessLevel");
        JavacNode node = (JavacNode)annotationNode.up();
        AccessLevel level = annotation.getInstance().value();
        if (level == AccessLevel.NONE || node == null) {
            return;
        }
        switch (node.getKind()) {
            case FIELD: {
                this.createWitherForFields(level, fields, annotationNode, true);
                break;
            }
            case TYPE: {
                this.generateWitherForType(node, annotationNode, level, false);
            }
        }
    }

    private void createWitherForFields(AccessLevel level, Collection<JavacNode> fieldNodes, JavacNode errorNode, boolean whineIfExists) {
        for (JavacNode fieldNode : fieldNodes) {
            this.createWitherForField(level, fieldNode, errorNode, whineIfExists);
        }
    }

    private void createWitherForField(AccessLevel level, JavacNode fieldNode, JavacNode source, boolean whineIfExists) {
        if (fieldNode.getKind() != AST.Kind.FIELD) {
            fieldNode.addError("@Wither is only supported on a class or a field.");
            return;
        }
        JCTree.JCVariableDecl fieldDecl = (JCTree.JCVariableDecl)fieldNode.get();
        String methodName = JavacHandlerUtil.toWitherName(fieldNode);
        if (methodName == null) {
            source.addWarning("Not generating wither for this field: It does not fit your @Accessors prefix list.");
            return;
        }
        if ((fieldDecl.mods.flags & 8L) != 0L) {
            source.addWarning("Not generating wither for this field: Withers cannot be generated for static fields.");
            return;
        }
        if ((fieldDecl.mods.flags & 0x10L) != 0L && fieldDecl.init != null) {
            source.addWarning("Not generating wither for this field: Withers cannot be generated for final, initialized fields.");
            return;
        }
        if (fieldDecl.name.toString().startsWith("$")) {
            source.addWarning("Not generating wither for this field: Withers cannot be generated for fields starting with $.");
            return;
        }
        for (String altName : JavacHandlerUtil.toAllWitherNames(fieldNode)) {
            switch (JavacHandlerUtil.methodExists(altName, fieldNode, false, 1)) {
                case EXISTS_BY_LOMBOK: {
                    return;
                }
                case EXISTS_BY_USER: {
                    if (whineIfExists) {
                        String altNameExpl = "";
                        if (!altName.equals(methodName)) {
                            altNameExpl = String.format(" (%s)", altName);
                        }
                        source.addWarning(String.format("Not generating %s(): A method with that name already exists%s", methodName, altNameExpl));
                    }
                    return;
                }
            }
        }
        long access = JavacHandlerUtil.toJavacModifier(level);
        JCTree.JCMethodDecl createdWither = this.createWither(access, fieldNode, fieldNode.getTreeMaker(), (JCTree)source.get());
        JavacHandlerUtil.injectMethod((JavacNode)fieldNode.up(), createdWither);
    }

    private JCTree.JCMethodDecl createWither(long access, JavacNode field, TreeMaker treeMaker, JCTree source) {
        String witherName = JavacHandlerUtil.toWitherName(field);
        if (witherName == null) {
            return null;
        }
        JCTree.JCVariableDecl fieldDecl = (JCTree.JCVariableDecl)field.get();
        ListBuffer statements = ListBuffer.lb();
        List<JCTree.JCAnnotation> nonNulls = JavacHandlerUtil.findAnnotations(field, TransformationsUtil.NON_NULL_PATTERN);
        List<JCTree.JCAnnotation> nullables = JavacHandlerUtil.findAnnotations(field, TransformationsUtil.NULLABLE_PATTERN);
        Name methodName = field.toName(witherName);
        List<JCTree.JCAnnotation> annsOnParam = nonNulls.appendList(nullables);
        JCTree.JCVariableDecl param = treeMaker.VarDef(treeMaker.Modifiers(16L, annsOnParam), fieldDecl.name, fieldDecl.vartype, null);
        JCTree.JCExpression selfType = JavacHandlerUtil.cloneSelfType(field);
        if (selfType == null) {
            return null;
        }
        TreeMaker maker = field.getTreeMaker();
        ListBuffer args = ListBuffer.lb();
        for (JavacNode child : ((JavacNode)field.up()).down()) {
            long fieldFlags;
            if (child.getKind() != AST.Kind.FIELD) continue;
            JCTree.JCVariableDecl childDecl = (JCTree.JCVariableDecl)child.get();
            if (childDecl.name.toString().startsWith("$") || ((fieldFlags = childDecl.mods.flags) & 8L) != 0L || (fieldFlags & 0x10L) != 0L && childDecl.init != null) continue;
            if (child.get() == field.get()) {
                args.append(maker.Ident(fieldDecl.name));
                continue;
            }
            args.append(JavacHandlerUtil.createFieldAccessor(maker, child, JavacHandlerUtil.FieldAccess.ALWAYS_FIELD));
        }
        JCTree.JCNewClass newClass = maker.NewClass(null, List.<JCTree.JCExpression>nil(), selfType, args.toList(), null);
        JCTree.JCBinary identityCheck = maker.Binary(Javac.getCtcInt(JCTree.class, "EQ"), JavacHandlerUtil.createFieldAccessor(maker, field, JavacHandlerUtil.FieldAccess.ALWAYS_FIELD), maker.Ident(fieldDecl.name));
        JCTree.JCConditional conditional = maker.Conditional(identityCheck, maker.Ident(field.toName("this")), newClass);
        JCTree.JCReturn returnStatement = maker.Return(conditional);
        if (nonNulls.isEmpty()) {
            statements.append(returnStatement);
        } else {
            JCTree.JCStatement nullCheck = JavacHandlerUtil.generateNullCheck(treeMaker, field);
            if (nullCheck != null) {
                statements.append(nullCheck);
            }
            statements.append(returnStatement);
        }
        JCTree.JCExpression returnType = JavacHandlerUtil.cloneSelfType(field);
        JCTree.JCBlock methodBody = treeMaker.Block(0L, statements.toList());
        List<JCTree.JCTypeParameter> methodGenericParams = List.nil();
        List<JCTree.JCVariableDecl> parameters = List.of(param);
        List<JCTree.JCExpression> throwsClauses = List.nil();
        JCTree.JCExpression annotationMethodDefaultValue = null;
        List<JCTree.JCAnnotation> annsOnMethod = List.nil();
        if (JavacHandlerUtil.isFieldDeprecated(field)) {
            annsOnMethod = annsOnMethod.prepend(treeMaker.Annotation(JavacHandlerUtil.chainDots(field, "java", "lang", "Deprecated"), List.<JCTree.JCExpression>nil()));
        }
        return JavacHandlerUtil.recursiveSetGeneratedBy(treeMaker.MethodDef(treeMaker.Modifiers(access, annsOnMethod), methodName, returnType, methodGenericParams, parameters, throwsClauses, methodBody, annotationMethodDefaultValue), source);
    }
}

