/*
 * Decompiled with CFR 0.152.
 */
package lombok.delombok;

import com.sun.tools.javac.main.JavaCompiler;
import com.sun.tools.javac.main.OptionName;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Options;
import java.io.IOException;
import java.io.Writer;
import java.util.Collections;
import java.util.Date;
import javax.annotation.processing.Messager;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticListener;
import javax.tools.JavaFileObject;
import lombok.delombok.Comment;
import lombok.delombok.CommentCollectingScanner;
import lombok.delombok.PrettyCommentsPrinter;
import lombok.javac.DeleteLombokAnnotations;
import lombok.javac.JavacTransformer;

public class CommentPreservingParser {
    private final String encoding;
    private boolean deleteLombokAnnotations = false;
    private DiagnosticListener<JavaFileObject> diagnostics = null;
    private static final Messager messager = new Messager(){

        @Override
        public void printMessage(Diagnostic.Kind kind, CharSequence msg) {
            System.out.printf("%s: %s\n", new Object[]{kind, msg});
        }

        @Override
        public void printMessage(Diagnostic.Kind kind, CharSequence msg, Element e) {
            System.out.printf("%s: %s\n", new Object[]{kind, msg});
        }

        @Override
        public void printMessage(Diagnostic.Kind kind, CharSequence msg, Element e, AnnotationMirror a) {
            System.out.printf("%s: %s\n", new Object[]{kind, msg});
        }

        @Override
        public void printMessage(Diagnostic.Kind kind, CharSequence msg, Element e, AnnotationMirror a, AnnotationValue v) {
            System.out.printf("%s: %s\n", new Object[]{kind, msg});
        }
    };

    public CommentPreservingParser() {
        this("utf-8");
    }

    public CommentPreservingParser(String encoding) {
        this.encoding = encoding;
    }

    public void setDeleteLombokAnnotations(boolean deleteLombokAnnotations) {
        this.deleteLombokAnnotations = deleteLombokAnnotations;
    }

    public void setDiagnosticsListener(DiagnosticListener<JavaFileObject> diagnostics) {
        this.diagnostics = diagnostics;
    }

    public ParseResult parse(JavaFileObject source, boolean forceProcessing) throws IOException {
        return this.doParse(source, forceProcessing);
    }

    public ParseResult parse(String fileName, boolean forceProcessing) throws IOException {
        return this.doParse(fileName, forceProcessing);
    }

    private ParseResult doParse(Object source, boolean forceProcessing) throws IOException {
        JCTree.JCCompilationUnit unit;
        Context context = new Context();
        Options.instance(context).put(OptionName.ENCODING, this.encoding);
        if (this.diagnostics != null) {
            context.put(DiagnosticListener.class, this.diagnostics);
        }
        CommentCollectingScanner.Factory.preRegister(context);
        JavaCompiler compiler = new JavaCompiler(context){

            @Override
            protected boolean keepComments() {
                return true;
            }
        };
        compiler.genEndPos = true;
        Comments comments = new Comments();
        context.put(Comments.class, comments);
        if (this.deleteLombokAnnotations) {
            context.put(DeleteLombokAnnotations.class, new DeleteLombokAnnotations(true));
        }
        comments.comments = List.nil();
        JCTree.JCCompilationUnit cu = source instanceof JavaFileObject ? compiler.parse((JavaFileObject)source) : (unit = compiler.parse((String)source));
        boolean changed = new JavacTransformer(messager).transform(context, Collections.singleton(cu));
        return new ParseResult(comments.comments, cu, forceProcessing || changed);
    }

    public static class ParseResult {
        private final List<Comment> comments;
        private final JCTree.JCCompilationUnit compilationUnit;
        private final boolean changed;

        private ParseResult(List<Comment> comments, JCTree.JCCompilationUnit compilationUnit, boolean changed) {
            this.comments = comments;
            this.compilationUnit = compilationUnit;
            this.changed = changed;
        }

        public void print(Writer out) throws IOException {
            JavaFileObject sourceFile;
            if (!this.changed && (sourceFile = this.compilationUnit.getSourceFile()) != null) {
                out.write(((Object)sourceFile.getCharContent(true)).toString());
                return;
            }
            out.write("// Generated by delombok at " + new Date() + "\n");
            this.compilationUnit.accept(new PrettyCommentsPrinter(out, this.compilationUnit, this.comments));
        }

        public boolean isChanged() {
            return this.changed;
        }
    }

    static class Comments {
        List<Comment> comments = List.nil();

        Comments() {
        }

        void add(Comment comment) {
            this.comments = this.comments.append(comment);
        }
    }
}

