/*
 * Decompiled with CFR 0.152.
 */
package lombok.eclipse.agent;

import java.lang.reflect.Field;
import java.util.ArrayList;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.SimpleName;

public class PatchFixes {
    public static final int ALREADY_PROCESSED_FLAG = 0x800000;

    public static int fixRetrieveStartingCatchPosition(int in) {
        return in;
    }

    public static boolean checkBit24(Object node) throws Exception {
        int bits = (Integer)node.getClass().getField("bits").get(node);
        return (bits & 0x800000) != 0;
    }

    public static boolean debugPrintStateOfScope(Object in) throws Exception {
        Object scope = in.getClass().getField("scope").get(in);
        String msg = null;
        if (scope == null) {
            msg = "scope itself is null";
        } else {
            Object sourceTypeBinding = scope.getClass().getMethod("enclosingSourceType", new Class[0]).invoke(scope, new Object[0]);
            if (sourceTypeBinding == null) {
                msg = "scope.enclosingSourceType() is null";
            }
        }
        if (msg != null) {
            throw new NullPointerException(msg);
        }
        return false;
    }

    public static boolean skipRewritingGeneratedNodes(ASTNode node) throws Exception {
        return (Boolean)node.getClass().getField("$isGenerated").get(node);
    }

    public static void setIsGeneratedFlag(ASTNode domNode, org.eclipse.jdt.internal.compiler.ast.ASTNode internalNode) throws Exception {
        boolean isGenerated;
        if (internalNode == null || domNode == null) {
            return;
        }
        boolean bl = isGenerated = internalNode.getClass().getField("$generatedBy").get(internalNode) != null;
        if (isGenerated) {
            domNode.getClass().getField("$isGenerated").set(domNode, true);
            domNode.setFlags(domNode.getFlags() & 0xFFFFFFFD);
        }
    }

    public static void setIsGeneratedFlagForSimpleName(SimpleName name, Object internalNode) throws Exception {
        if (internalNode instanceof org.eclipse.jdt.internal.compiler.ast.ASTNode && internalNode.getClass().getField("$generatedBy").get(internalNode) != null) {
            name.getClass().getField("$isGenerated").set(name, true);
        }
    }

    public static IMethod[] removeGeneratedMethods(IMethod[] methods) throws Exception {
        ArrayList<IMethod> result = new ArrayList<IMethod>();
        for (IMethod m : methods) {
            if (m.getNameRange().getLength() <= 0) continue;
            result.add(m);
        }
        return result.size() == methods.length ? methods : result.toArray(new IMethod[0]);
    }

    public static SimpleName[] removeGeneratedSimpleNames(SimpleName[] in) throws Exception {
        Field f = SimpleName.class.getField("$isGenerated");
        int count = 0;
        for (int i = 0; i < in.length; ++i) {
            if (in[i] != null && ((Boolean)f.get(in[i])).booleanValue()) continue;
            ++count;
        }
        if (count == in.length) {
            return in;
        }
        SimpleName[] newSimpleNames = new SimpleName[count];
        count = 0;
        for (int i = 0; i < in.length; ++i) {
            if (in[i] != null && ((Boolean)f.get(in[i])).booleanValue()) continue;
            newSimpleNames[count++] = in[i];
        }
        return newSimpleNames;
    }
}

