/*
 * Decompiled with CFR 0.152.
 */
package lombok.eclipse.apt;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.TypeElement;
import lombok.Lombok;
import lombok.eclipse.TransformEclipseAST;
import lombok.patcher.inject.LiveInjector;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.apt.dispatch.BaseProcessingEnvImpl;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.jdt.internal.compiler.parser.Parser;
import org.eclipse.jdt.internal.compiler.util.HashtableOfType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@SupportedAnnotationTypes(value={"*"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_6)
public class Processor
extends AbstractProcessor {
    private BaseProcessingEnvImpl processingEnv;

    @Override
    public synchronized void init(ProcessingEnvironment procEnv) {
        super.init(procEnv);
        this.processingEnv = (BaseProcessingEnvImpl)procEnv;
        if (this.eclipseNeedsPatching()) {
            new LiveInjector().injectSelf();
        }
    }

    private boolean eclipseNeedsPatching() {
        try {
            return Class.forName("org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration").getDeclaredField("$lombokAST") == null;
        }
        catch (Exception ignore) {
            return true;
        }
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        CompilationUnitDeclaration[] roots = (CompilationUnitDeclaration[])Processor.fieldAccess(roundEnv, "_units");
        if (roots == null) {
            return false;
        }
        for (CompilationUnitDeclaration cud : roots) {
            Processor.fullParseType(this.processingEnv.getCompiler().parser, cud, cud.types);
            TransformEclipseAST.transform(null, cud);
        }
        HashMap<PackageBinding, List<char[]>> packageToTypeNames = new HashMap<PackageBinding, List<char[]>>();
        for (CompilationUnitDeclaration cud : roots) {
            Processor.addToClearTracker(packageToTypeNames, new char[0], cud.scope.fPackage, cud.types);
        }
        for (Map.Entry e : packageToTypeNames.entrySet()) {
            if (((List)e.getValue()).isEmpty()) continue;
            HashtableOfType knownTypes = (HashtableOfType)Processor.fieldAccess(e.getKey(), "knownTypes");
            for (int i = 0; i < knownTypes.keyTable.length; ++i) {
                if (knownTypes.keyTable[i] == null) continue;
                for (char[] toClear : (List)e.getValue()) {
                    if (!CharOperation.equals((char[])knownTypes.keyTable[i], (char[])toClear)) continue;
                    knownTypes.keyTable[i] = null;
                }
            }
            Processor.methodInvoke(knownTypes, "rehash");
        }
        for (CompilationUnitDeclaration cud : roots) {
            cud.scope = null;
            cud.types[0].binding = null;
            cud.types[0].scope = null;
            this.processingEnv.getLookupEnvironment().buildTypeBindings(cud, null);
        }
        this.processingEnv.getLookupEnvironment().completeTypeBindings();
        return false;
    }

    private static void fullParseType(Parser parser, CompilationUnitDeclaration cud, TypeDeclaration[] typeDecls) {
        if (typeDecls == null) {
            return;
        }
        for (TypeDeclaration typeDecl : typeDecls) {
            for (AbstractMethodDeclaration methodDecl : typeDecl.methods) {
                methodDecl.parseStatements(parser, cud);
                methodDecl.bits |= 0x800000;
            }
            Processor.fullParseType(parser, cud, typeDecl.memberTypes);
        }
    }

    private static void addToClearTracker(Map<PackageBinding, List<char[]>> packageToTypeNames, char[] prefix, PackageBinding packageBinding, TypeDeclaration[] typeDecls) {
        if (typeDecls == null) {
            return;
        }
        List<char[]> names = packageToTypeNames.get(packageBinding);
        if (names == null) {
            names = new ArrayList<char[]>();
            packageToTypeNames.put(packageBinding, names);
        }
        for (TypeDeclaration typeDecl : typeDecls) {
            char[] name;
            if (prefix.length == 0) {
                name = typeDecl.name;
            } else {
                name = Arrays.copyOf(prefix, prefix.length + typeDecl.name.length);
                System.arraycopy(typeDecl.name, 0, name, prefix.length, typeDecl.name.length);
            }
            names.add(name);
            if (typeDecl.memberTypes == null || typeDecl.memberTypes.length <= 0) continue;
            char[] newPrefix = Arrays.copyOf(name, name.length + 1);
            newPrefix[newPrefix.length - 1] = 36;
            Processor.addToClearTracker(packageToTypeNames, newPrefix, packageBinding, typeDecl.memberTypes);
        }
    }

    private static void methodInvoke(Object object, String methodName) {
        try {
            Method m = object.getClass().getDeclaredMethod(methodName, new Class[0]);
            m.setAccessible(true);
            m.invoke(object, new Object[0]);
        }
        catch (Exception e) {
            throw Lombok.sneakyThrow(e);
        }
    }

    private static Object fieldAccess(Object object, String fieldName) {
        try {
            Field f = object.getClass().getDeclaredField(fieldName);
            f.setAccessible(true);
            return f.get(object);
        }
        catch (Exception e) {
            throw Lombok.sneakyThrow(e);
        }
    }
}

