/*
 * Decompiled with CFR 0.152.
 */
package lombok.eclipse.handlers;

import java.util.Collection;
import lombok.AccessLevel;
import lombok.Getter;
import lombok.core.AST;
import lombok.core.AnnotationValues;
import lombok.core.handlers.TransformationsUtil;
import lombok.eclipse.Eclipse;
import lombok.eclipse.EclipseAnnotationHandler;
import lombok.eclipse.EclipseNode;
import lombok.eclipse.handlers.EclipseHandlerUtil;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.ast.FieldReference;
import org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.ReturnStatement;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.ast.ThisReference;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HandleGetter
implements EclipseAnnotationHandler<Getter> {
    public boolean generateGetterForType(EclipseNode typeNode, EclipseNode pos, AccessLevel level, boolean checkForTypeLevelGetter) {
        boolean notAClass;
        if (checkForTypeLevelGetter && typeNode != null) {
            for (EclipseNode child : typeNode.down()) {
                if (child.getKind() != AST.Kind.ANNOTATION || !Eclipse.annotationTypeMatches(Getter.class, child)) continue;
                return true;
            }
        }
        TypeDeclaration typeDecl = null;
        if (typeNode.get() instanceof TypeDeclaration) {
            typeDecl = (TypeDeclaration)typeNode.get();
        }
        int modifiers = typeDecl == null ? 0 : typeDecl.modifiers;
        boolean bl = notAClass = (modifiers & 0x6200) != 0;
        if (typeDecl == null || notAClass) {
            pos.addError("@Getter is only supported on a class or a field.");
            return false;
        }
        for (EclipseNode field : typeNode.down()) {
            if (!this.fieldQualifiesForGetterGeneration(field)) continue;
            this.generateGetterForField(field, (ASTNode)pos.get(), level);
        }
        return true;
    }

    public boolean fieldQualifiesForGetterGeneration(EclipseNode field) {
        if (field.getKind() != AST.Kind.FIELD) {
            return false;
        }
        FieldDeclaration fieldDecl = (FieldDeclaration)field.get();
        if (fieldDecl.name.length > 0 && fieldDecl.name[0] == '$') {
            return false;
        }
        return (fieldDecl.modifiers & 8) == 0;
    }

    public void generateGetterForField(EclipseNode fieldNode, ASTNode pos, AccessLevel level) {
        for (EclipseNode child : fieldNode.down()) {
            if (child.getKind() != AST.Kind.ANNOTATION || !Eclipse.annotationTypeMatches(Getter.class, child)) continue;
            return;
        }
        this.createGetterForField(level, fieldNode, fieldNode, pos, false);
    }

    @Override
    public boolean handle(AnnotationValues<Getter> annotation, Annotation ast, EclipseNode annotationNode) {
        EclipseNode node = (EclipseNode)annotationNode.up();
        AccessLevel level = annotation.getInstance().value();
        if (level == AccessLevel.NONE) {
            return true;
        }
        if (node == null) {
            return false;
        }
        if (node.getKind() == AST.Kind.FIELD) {
            return this.createGetterForFields(level, annotationNode.upFromAnnotationToFields(), annotationNode, (ASTNode)annotationNode.get(), true);
        }
        if (node.getKind() == AST.Kind.TYPE) {
            return this.generateGetterForType(node, annotationNode, level, false);
        }
        return false;
    }

    private boolean createGetterForFields(AccessLevel level, Collection<EclipseNode> fieldNodes, EclipseNode errorNode, ASTNode source, boolean whineIfExists) {
        for (EclipseNode fieldNode : fieldNodes) {
            this.createGetterForField(level, fieldNode, errorNode, source, whineIfExists);
        }
        return true;
    }

    private boolean createGetterForField(AccessLevel level, EclipseNode fieldNode, EclipseNode errorNode, ASTNode source, boolean whineIfExists) {
        if (fieldNode.getKind() != AST.Kind.FIELD) {
            errorNode.addError("@Getter is only supported on a class or a field.");
            return true;
        }
        FieldDeclaration field = (FieldDeclaration)fieldNode.get();
        TypeReference fieldType = Eclipse.copyType(field.type, source);
        String fieldName = new String(field.name);
        boolean isBoolean = EclipseHandlerUtil.nameEquals(fieldType.getTypeName(), "boolean") && fieldType.dimensions() == 0;
        String getterName = TransformationsUtil.toGetterName(fieldName, isBoolean);
        int modifier = EclipseHandlerUtil.toEclipseModifier(level) | field.modifiers & 8;
        for (String altName : TransformationsUtil.toAllGetterNames(fieldName, isBoolean)) {
            switch (EclipseHandlerUtil.methodExists(altName, fieldNode, false)) {
                case EXISTS_BY_LOMBOK: {
                    return true;
                }
                case EXISTS_BY_USER: {
                    if (whineIfExists) {
                        String altNameExpl = "";
                        if (!altName.equals(getterName)) {
                            altNameExpl = String.format(" (%s)", altName);
                        }
                        errorNode.addWarning(String.format("Not generating %s(): A method with that name already exists%s", getterName, altNameExpl));
                    }
                    return true;
                }
            }
        }
        MethodDeclaration method = this.generateGetter((TypeDeclaration)((EclipseNode)fieldNode.up()).get(), field, getterName, modifier, source);
        Annotation[] copiedAnnotations = Eclipse.copyAnnotations(EclipseHandlerUtil.findAnnotations(field, TransformationsUtil.NON_NULL_PATTERN), EclipseHandlerUtil.findAnnotations(field, TransformationsUtil.NULLABLE_PATTERN), source);
        if (copiedAnnotations.length != 0) {
            method.annotations = copiedAnnotations;
        }
        EclipseHandlerUtil.injectMethod((EclipseNode)fieldNode.up(), (AbstractMethodDeclaration)method);
        return true;
    }

    private MethodDeclaration generateGetter(TypeDeclaration parent, FieldDeclaration field, String name, int modifier, ASTNode source) {
        MethodDeclaration method = new MethodDeclaration(parent.compilationResult);
        Eclipse.setGeneratedBy((ASTNode)method, source);
        method.modifiers = modifier;
        method.returnType = Eclipse.copyType(field.type, source);
        method.annotations = null;
        method.arguments = null;
        method.selector = name.toCharArray();
        method.binding = null;
        method.thrownExceptions = null;
        method.typeParameters = null;
        method.bits |= 0x800000;
        long p = (long)field.declarationSourceStart << 32 | (long)field.declarationSourceEnd;
        FieldReference thisX = new FieldReference(field.name, p);
        Eclipse.setGeneratedBy((ASTNode)thisX, source);
        thisX.receiver = new ThisReference(source.sourceStart, source.sourceEnd);
        Eclipse.setGeneratedBy((ASTNode)thisX.receiver, source);
        ReturnStatement returnStatement = new ReturnStatement((Expression)thisX, field.sourceStart, field.sourceEnd);
        Eclipse.setGeneratedBy((ASTNode)returnStatement, source);
        method.declarationSourceStart = method.sourceStart = source.sourceStart;
        method.bodyStart = method.sourceStart;
        method.declarationSourceEnd = method.sourceEnd = source.sourceEnd;
        method.bodyEnd = method.sourceEnd;
        method.statements = new Statement[]{returnStatement};
        return method;
    }
}

