/*
 * Decompiled with CFR 0.152.
 */
package lombok.installer.netbeans;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.installer.CorruptedIdeLocationException;
import lombok.installer.IdeFinder;
import lombok.installer.IdeLocation;
import lombok.installer.InstallException;
import lombok.installer.Installer;
import lombok.installer.UninstallException;

public class NetbeansLocation
extends IdeLocation {
    private final String name;
    private final File netbeansConfPath;
    private final String version;
    private final int versionFirst;
    private final int versionSecond;
    private final boolean hasLombok;
    private static final String OS_NEWLINE = IdeFinder.getOS().getLineEnding();
    private final String ID_CHARS = "(?:\\\\.|[^\"\\\\])*";
    private final Pattern JAVA_AGENT_LINE_MATCHER = Pattern.compile("^\\s*netbeans_default_options\\s*=\\s*\"\\s*(?:\\\\.|[^\"\\\\])*(?<=[ \"])(-J-javaagent:\\\\\".*lombok.*\\.jar\\\\\")(?=[ \"])(?:\\\\.|[^\"\\\\])*\\s*\"\\s*(?:#.*)?$", 2);
    private final Pattern OPTIONS_LINE_MATCHER = Pattern.compile("^\\s*netbeans_default_options\\s*=\\s*\"\\s*(?:\\\\.|[^\"\\\\])*\\s*(\")\\s*(?:#.*)?$", 2);

    NetbeansLocation(String nameOfLocation, File pathToNetbeansConf) throws CorruptedIdeLocationException {
        int second;
        int first;
        this.name = nameOfLocation;
        this.netbeansConfPath = pathToNetbeansConf;
        try {
            this.hasLombok = this.checkForLombok(this.netbeansConfPath);
        }
        catch (IOException e) {
            throw new CorruptedIdeLocationException("I can't read the configuration file of the Netbeans installed at " + this.name + "\n" + "You may need to run this installer with root privileges if you want to modify that Netbeans.", "netbeans", e);
        }
        this.version = this.findNetbeansVersion(this.netbeansConfPath);
        String[] vs = this.version.split("\\.");
        try {
            first = Integer.parseInt(vs[0]);
        }
        catch (Exception e) {
            first = 0;
        }
        try {
            second = Integer.parseInt(vs[1]);
        }
        catch (Exception e) {
            second = 0;
        }
        this.versionFirst = first;
        this.versionSecond = second;
    }

    public boolean versionIsPre68() {
        return this.versionFirst < 6 || this.versionFirst == 6 && this.versionSecond < 8;
    }

    public boolean versionIs68() {
        return this.versionFirst == 6 && this.versionSecond == 8;
    }

    public boolean versionIsPost68() {
        return this.versionFirst > 6 || this.versionFirst == 6 && this.versionSecond > 8;
    }

    public int hashCode() {
        return this.netbeansConfPath.hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof NetbeansLocation)) {
            return false;
        }
        return ((NetbeansLocation)o).netbeansConfPath.equals(this.netbeansConfPath);
    }

    public String getName() {
        return this.name;
    }

    public boolean hasLombok() {
        return this.hasLombok;
    }

    private String findNetbeansVersion(File iniFile) {
        String forcedVersion = System.getProperty("force.netbeans.version", null);
        if (forcedVersion != null) {
            return forcedVersion;
        }
        try {
            for (File child : iniFile.getParentFile().getParentFile().listFiles()) {
                String name;
                if (!child.isDirectory() || (name = child.getName()) == null || !name.startsWith("nb")) continue;
                String version = name.substring(2);
                File versionFile = new File(child, "VERSION.txt");
                if (versionFile.exists() && versionFile.canRead() && !versionFile.isDirectory()) {
                    try {
                        version = NetbeansLocation.readVersionFile(versionFile);
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
                if (version == null || version.length() <= 0) continue;
                return version;
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return "UNKNOWN";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readVersionFile(File file) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        StringBuilder version = new StringBuilder();
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)fis, "UTF-8"));
            String line = br.readLine();
            while (line != null) {
                if (!line.startsWith("#")) {
                    if (version.length() > 0) {
                        version.append(" ");
                    }
                    version.append(line);
                }
                line = br.readLine();
            }
            String string = version.toString();
            return string;
        }
        finally {
            fis.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkForLombok(File iniFile) throws IOException {
        if (!iniFile.exists()) {
            return false;
        }
        FileInputStream fis = new FileInputStream(iniFile);
        try {
            String line;
            BufferedReader br = new BufferedReader(new InputStreamReader(fis));
            while ((line = br.readLine()) != null) {
                if (!this.JAVA_AGENT_LINE_MATCHER.matcher(line.trim()).matches()) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            fis.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void uninstall() throws UninstallException {
        File lombokJar;
        ArrayList<File> lombokJarsForWhichCantDeleteSelf = new ArrayList<File>();
        File dir = this.netbeansConfPath.getParentFile();
        StringBuilder newContents = new StringBuilder();
        if (this.netbeansConfPath.exists()) {
            try {
                FileInputStream fis = new FileInputStream(this.netbeansConfPath);
                try {
                    String line;
                    BufferedReader br = new BufferedReader(new InputStreamReader(fis));
                    while ((line = br.readLine()) != null) {
                        Matcher m = this.JAVA_AGENT_LINE_MATCHER.matcher(line);
                        if (m.matches()) {
                            newContents.append(line.substring(0, m.start(1)) + line.substring(m.end(1)));
                        } else {
                            newContents.append(line);
                        }
                        newContents.append(OS_NEWLINE);
                    }
                }
                finally {
                    fis.close();
                }
                FileOutputStream fos = new FileOutputStream(this.netbeansConfPath);
                try {
                    fos.write(newContents.toString().getBytes());
                }
                finally {
                    fos.close();
                }
            }
            catch (IOException e) {
                throw new UninstallException("Cannot uninstall lombok from " + this.name + NetbeansLocation.generateWriteErrorMessage(), e);
            }
        }
        if ((lombokJar = new File(dir, "lombok.jar")).exists() && !lombokJar.delete()) {
            if (IdeFinder.getOS() == IdeFinder.OS.WINDOWS && Installer.isSelf(lombokJar.getAbsolutePath())) {
                lombokJarsForWhichCantDeleteSelf.add(lombokJar);
            } else {
                throw new UninstallException("Can't delete " + lombokJar.getAbsolutePath() + NetbeansLocation.generateWriteErrorMessage(), null);
            }
        }
        if (!lombokJarsForWhichCantDeleteSelf.isEmpty()) {
            throw new UninstallException(true, "lombok.jar cannot delete itself on windows.\nHowever, lombok has been uncoupled from your netbeans.\nYou can safely delete this jar file. You can find it at:\n" + ((File)lombokJarsForWhichCantDeleteSelf.get(0)).getAbsolutePath(), null);
        }
    }

    private static String generateWriteErrorMessage() {
        String osSpecificError;
        switch (IdeFinder.getOS()) {
            default: {
                osSpecificError = ":\nStart terminal, go to the directory with lombok.jar, and run: sudo java -jar lombok.jar";
                break;
            }
            case WINDOWS: {
                osSpecificError = ":\nStart a new cmd (dos box) with admin privileges, go to the directory with lombok.jar, and run: java -jar lombok.jar";
            }
        }
        return ", probably because this installer does not have the access rights.\nTry re-running the installer with administrative privileges" + osSpecificError;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String install() throws InstallException {
        if ("UNKNOWN".equals(this.version)) {
            throw new InstallException(String.format("Can't determine version of Netbeans installed at:\n%s\n\nYour Netbeans version determines what this installer does:\nPre 6.8: Lombok is not compatible with netbeans pre 6.8, and thus won't install.\n6.8: Lombok will install itself into Netbeans.\n6.9 and later: NetBeans supports lombok natively. This installer will explain how to enable it.\n\nIf you know your netbeans version, you can force this by starting the installer with:\njava -Dforce.netbeans.version=6.8 -jar lombok.jar", this.getName()), null);
        }
        if (this.versionIsPre68()) {
            throw new InstallException(String.format("Lombok is not compatible with Netbeans versions prior to 6.8.\nTherefore, lombok will not be installed at:\n%s\nbecause it is version: %s", this.getName(), this.version), null);
        }
        if (this.versionIsPost68()) {
            try {
                this.uninstall();
            }
            catch (Exception e) {
                // empty catch block
            }
            throw new InstallException(true, String.format("Starting with NetBeans 6.9, lombok is natively supported and does not need to be installed at:\n%s\n\nTo use lombok.jar in your netbeans project:\n1. Add lombok.jar to your project (Go to Project Properties, 'Libraries' page, and add lombok.jar in the 'Compile' tab).\n2. Enable Annotation Processors (Go to Project Properties, 'Build/Compiling' page, and check 'Enable Annotation Processing in Editor').\n\nNB: In the first release of NetBeans 6.9, due to a netbeans bug, maven-based projects don't run annotation processors. This \nissue should be fixed by the great folks at NetBeans soon.", this.getName()), null);
        }
        boolean installSucceeded = false;
        StringBuilder newContents = new StringBuilder();
        File lombokJar = new File(this.netbeansConfPath.getParentFile(), "lombok.jar");
        if (!Installer.isSelf(lombokJar.getAbsolutePath())) {
            File ourJar = NetbeansLocation.findOurJar();
            byte[] b = new byte[524288];
            boolean readSucceeded = true;
            try {
                FileOutputStream out = new FileOutputStream(lombokJar);
                try {
                    readSucceeded = false;
                    FileInputStream in = new FileInputStream(ourJar);
                    try {
                        int r;
                        while ((r = ((InputStream)in).read(b)) != -1) {
                            if (r > 0) {
                                readSucceeded = true;
                            }
                            out.write(b, 0, r);
                        }
                    }
                    finally {
                        ((InputStream)in).close();
                    }
                }
                finally {
                    out.close();
                }
            }
            catch (IOException e) {
                try {
                    lombokJar.delete();
                }
                catch (Throwable ignore) {
                    // empty catch block
                }
                if (!readSucceeded) {
                    throw new InstallException("I can't read my own jar file. I think you've found a bug in this installer!\nI suggest you restart it and use the 'what do I do' link, to manually install lombok. Also, tell us about this at:\nhttp://groups.google.com/group/project-lombok - Thanks!", e);
                }
                throw new InstallException("I can't write to your Netbeans directory at " + this.name + NetbeansLocation.generateWriteErrorMessage(), e);
            }
        }
        try {
            FileInputStream fis = new FileInputStream(this.netbeansConfPath);
            try {
                String line;
                BufferedReader br = new BufferedReader(new InputStreamReader(fis));
                while ((line = br.readLine()) != null) {
                    Matcher m = this.JAVA_AGENT_LINE_MATCHER.matcher(line);
                    if (m.matches()) {
                        newContents.append(line.substring(0, m.start(1)));
                        newContents.append("-J-javaagent:\\\"" + NetbeansLocation.canonical(lombokJar) + "\\\"");
                        newContents.append(line.substring(m.end(1)));
                        newContents.append(OS_NEWLINE);
                        continue;
                    }
                    m = this.OPTIONS_LINE_MATCHER.matcher(line);
                    if (m.matches()) {
                        newContents.append(line.substring(0, m.start(1)));
                        newContents.append(" ").append("-J-javaagent:\\\"" + NetbeansLocation.canonical(lombokJar) + "\\\"\"");
                        newContents.append(line.substring(m.end(1))).append(OS_NEWLINE);
                        continue;
                    }
                    newContents.append(line).append(OS_NEWLINE);
                }
            }
            finally {
                fis.close();
            }
            FileOutputStream fos = new FileOutputStream(this.netbeansConfPath);
            try {
                fos.write(newContents.toString().getBytes());
            }
            finally {
                fos.close();
            }
            installSucceeded = true;
        }
        catch (IOException e) {
            throw new InstallException("Cannot install lombok at " + this.name + NetbeansLocation.generateWriteErrorMessage(), e);
        }
        finally {
            if (!installSucceeded) {
                try {
                    lombokJar.delete();
                }
                catch (Throwable ignore) {}
            }
        }
        if (!installSucceeded) {
            throw new InstallException("I can't find the netbeans.conf file. Is this a real Netbeans installation?", null);
        }
        return "If you start netbeans with custom parameters, you'll need to add:<br><code>-J-javaagent:\\\"" + NetbeansLocation.canonical(lombokJar) + "\\\"</code><br>" + "as parameter as well.";
    }

    public URL getIdeIcon() {
        return NetbeansLocation.class.getResource("netbeans.png");
    }
}

