/*
 * Decompiled with CFR 0.152.
 */
package lombok.eclipse.handlers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.AccessLevel;
import lombok.Delegate;
import lombok.Getter;
import lombok.core.AST;
import lombok.core.AnnotationValues;
import lombok.core.TransformationsUtil;
import lombok.eclipse.Eclipse;
import lombok.eclipse.EclipseAnnotationHandler;
import lombok.eclipse.EclipseNode;
import lombok.eclipse.agent.PatchDelegate;
import lombok.eclipse.handlers.EclipseHandlerUtil;
import lombok.eclipse.handlers.SetGeneratedByVisitor;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.AllocationExpression;
import org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.eclipse.jdt.internal.compiler.ast.ArrayTypeReference;
import org.eclipse.jdt.internal.compiler.ast.Assignment;
import org.eclipse.jdt.internal.compiler.ast.Block;
import org.eclipse.jdt.internal.compiler.ast.CastExpression;
import org.eclipse.jdt.internal.compiler.ast.ConditionalExpression;
import org.eclipse.jdt.internal.compiler.ast.EqualExpression;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.ast.IfStatement;
import org.eclipse.jdt.internal.compiler.ast.LocalDeclaration;
import org.eclipse.jdt.internal.compiler.ast.MessageSend;
import org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.NullLiteral;
import org.eclipse.jdt.internal.compiler.ast.ParameterizedQualifiedTypeReference;
import org.eclipse.jdt.internal.compiler.ast.QualifiedTypeReference;
import org.eclipse.jdt.internal.compiler.ast.ReturnStatement;
import org.eclipse.jdt.internal.compiler.ast.SingleNameReference;
import org.eclipse.jdt.internal.compiler.ast.SingleTypeReference;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.ast.SynchronizedStatement;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HandleGetter
extends EclipseAnnotationHandler<Getter> {
    private static final Annotation[] EMPTY_ANNOTATIONS_ARRAY = new Annotation[0];
    private static final char[][] AR = Eclipse.fromQualifiedName("java.util.concurrent.atomic.AtomicReference");
    public static final Map<String, char[][]> TYPE_MAP;
    private static char[] valueName;
    private static char[] actualValueName;
    private static final int PARENTHESIZED = 0x200000;

    public boolean generateGetterForType(EclipseNode typeNode, EclipseNode pos, AccessLevel level, boolean checkForTypeLevelGetter) {
        boolean notAClass;
        if (checkForTypeLevelGetter && EclipseHandlerUtil.hasAnnotation(Getter.class, typeNode)) {
            return true;
        }
        TypeDeclaration typeDecl = null;
        if (typeNode.get() instanceof TypeDeclaration) {
            typeDecl = (TypeDeclaration)typeNode.get();
        }
        int modifiers = typeDecl == null ? 0 : typeDecl.modifiers;
        boolean bl = notAClass = (modifiers & 0x2200) != 0;
        if (typeDecl == null || notAClass) {
            pos.addError("@Getter is only supported on a class, an enum, or a field.");
            return false;
        }
        for (EclipseNode field : typeNode.down()) {
            if (!this.fieldQualifiesForGetterGeneration(field)) continue;
            this.generateGetterForField(field, (ASTNode)pos.get(), level, false);
        }
        return true;
    }

    public boolean fieldQualifiesForGetterGeneration(EclipseNode field) {
        if (field.getKind() != AST.Kind.FIELD) {
            return false;
        }
        FieldDeclaration fieldDecl = (FieldDeclaration)field.get();
        return EclipseHandlerUtil.filterField(fieldDecl);
    }

    public void generateGetterForField(EclipseNode fieldNode, ASTNode pos, AccessLevel level, boolean lazy) {
        if (EclipseHandlerUtil.hasAnnotation(Getter.class, fieldNode)) {
            return;
        }
        this.createGetterForField(level, fieldNode, fieldNode, pos, false, lazy, Collections.<Annotation>emptyList());
    }

    @Override
    public void handle(AnnotationValues<Getter> annotation, Annotation ast, EclipseNode annotationNode) {
        EclipseNode node = (EclipseNode)annotationNode.up();
        Getter annotationInstance = annotation.getInstance();
        AccessLevel level = annotationInstance.value();
        boolean lazy = annotationInstance.lazy();
        if (level == AccessLevel.NONE) {
            if (lazy) {
                annotationNode.addWarning("'lazy' does not work with AccessLevel.NONE.");
            }
            return;
        }
        if (node == null) {
            return;
        }
        List<Annotation> onMethod = EclipseHandlerUtil.unboxAndRemoveAnnotationParameter(ast, "onMethod", "@Getter(onMethod=", annotationNode);
        switch (node.getKind()) {
            case FIELD: {
                this.createGetterForFields(level, annotationNode.upFromAnnotationToFields(), annotationNode, (ASTNode)annotationNode.get(), true, lazy, onMethod);
                break;
            }
            case TYPE: {
                if (!onMethod.isEmpty()) {
                    annotationNode.addError("'onMethod' is not supported for @Getter on a type.");
                }
                if (lazy) {
                    annotationNode.addError("'lazy' is not supported for @Getter on a type.");
                }
                this.generateGetterForType(node, annotationNode, level, false);
            }
        }
    }

    public void createGetterForFields(AccessLevel level, Collection<EclipseNode> fieldNodes, EclipseNode errorNode, ASTNode source, boolean whineIfExists, boolean lazy, List<Annotation> onMethod) {
        for (EclipseNode fieldNode : fieldNodes) {
            this.createGetterForField(level, fieldNode, errorNode, source, whineIfExists, lazy, onMethod);
        }
    }

    public void createGetterForField(AccessLevel level, EclipseNode fieldNode, EclipseNode errorNode, ASTNode source, boolean whineIfExists, boolean lazy, List<Annotation> onMethod) {
        TypeReference fieldType;
        boolean isBoolean;
        String getterName;
        if (fieldNode.getKind() != AST.Kind.FIELD) {
            errorNode.addError("@Getter is only supported on a class or a field.");
            return;
        }
        FieldDeclaration field = (FieldDeclaration)fieldNode.get();
        if (lazy) {
            if ((field.modifiers & 2) == 0 || (field.modifiers & 0x10) == 0) {
                errorNode.addError("'lazy' requires the field to be private and final.");
                return;
            }
            if (field.initialization == null) {
                errorNode.addError("'lazy' requires field initialization.");
                return;
            }
        }
        if ((getterName = EclipseHandlerUtil.toGetterName(fieldNode, isBoolean = EclipseHandlerUtil.isBoolean(fieldType = EclipseHandlerUtil.copyType(field.type, source)))) == null) {
            errorNode.addWarning("Not generating getter for this field: It does not fit your @Accessors prefix list.");
            return;
        }
        int modifier = EclipseHandlerUtil.toEclipseModifier(level) | field.modifiers & 8;
        for (String altName : EclipseHandlerUtil.toAllGetterNames(fieldNode, isBoolean)) {
            switch (EclipseHandlerUtil.methodExists(altName, fieldNode, false, 0)) {
                case EXISTS_BY_LOMBOK: {
                    return;
                }
                case EXISTS_BY_USER: {
                    if (whineIfExists) {
                        String altNameExpl = "";
                        if (!altName.equals(getterName)) {
                            altNameExpl = String.format(" (%s)", altName);
                        }
                        errorNode.addWarning(String.format("Not generating %s(): A method with that name already exists%s", getterName, altNameExpl));
                    }
                    return;
                }
            }
        }
        MethodDeclaration method = this.createGetter((TypeDeclaration)((EclipseNode)fieldNode.up()).get(), fieldNode, getterName, modifier, source, lazy, onMethod);
        EclipseHandlerUtil.injectMethod((EclipseNode)fieldNode.up(), (AbstractMethodDeclaration)method);
    }

    public static Annotation[] findDelegatesAndMarkAsHandled(EclipseNode fieldNode) {
        ArrayList<Annotation> delegates = new ArrayList<Annotation>();
        for (EclipseNode child : fieldNode.down()) {
            if (!EclipseHandlerUtil.annotationTypeMatches(Delegate.class, child)) continue;
            Annotation delegate = (Annotation)child.get();
            PatchDelegate.markHandled(delegate);
            delegates.add(delegate);
        }
        return delegates.toArray(EMPTY_ANNOTATIONS_ARRAY);
    }

    public MethodDeclaration createGetter(TypeDeclaration parent, EclipseNode fieldNode, String name, int modifier, ASTNode source, boolean lazy, List<Annotation> onMethod) {
        Annotation[] copiedAnnotations;
        FieldDeclaration field = (FieldDeclaration)fieldNode.get();
        TypeReference returnType = EclipseHandlerUtil.copyType(((FieldDeclaration)fieldNode.get()).type, source);
        Statement[] statements = lazy ? this.createLazyGetterBody(source, fieldNode) : this.createSimpleGetterBody(source, fieldNode);
        MethodDeclaration method = new MethodDeclaration(parent.compilationResult);
        method.modifiers = modifier;
        method.returnType = returnType;
        method.annotations = null;
        method.arguments = null;
        method.selector = name.toCharArray();
        method.binding = null;
        method.thrownExceptions = null;
        method.typeParameters = null;
        method.bits |= 0x800000;
        method.declarationSourceStart = method.sourceStart = source.sourceStart;
        method.bodyStart = method.sourceStart;
        method.declarationSourceEnd = method.sourceEnd = source.sourceEnd;
        method.bodyEnd = method.sourceEnd;
        method.statements = statements;
        EclipseHandlerUtil.registerCreatedLazyGetter((FieldDeclaration)fieldNode.get(), method.selector, returnType);
        Annotation[] deprecated = null;
        if (EclipseHandlerUtil.isFieldDeprecated(fieldNode)) {
            deprecated = new Annotation[]{EclipseHandlerUtil.generateDeprecatedAnnotation(source)};
        }
        if ((copiedAnnotations = EclipseHandlerUtil.copyAnnotations(source, onMethod.toArray(new Annotation[0]), Eclipse.findAnnotations(field, TransformationsUtil.NON_NULL_PATTERN), Eclipse.findAnnotations(field, TransformationsUtil.NULLABLE_PATTERN), HandleGetter.findDelegatesAndMarkAsHandled(fieldNode), deprecated)).length != 0) {
            method.annotations = copiedAnnotations;
        }
        method.traverse((ASTVisitor)new SetGeneratedByVisitor(source), parent.scope);
        return method;
    }

    public Statement[] createSimpleGetterBody(ASTNode source, EclipseNode fieldNode) {
        FieldDeclaration field = (FieldDeclaration)fieldNode.get();
        Expression fieldRef = EclipseHandlerUtil.createFieldAccessor(fieldNode, EclipseHandlerUtil.FieldAccess.ALWAYS_FIELD, source);
        ReturnStatement returnStatement = new ReturnStatement(fieldRef, field.sourceStart, field.sourceEnd);
        return new Statement[]{returnStatement};
    }

    public Statement[] createLazyGetterBody(ASTNode source, EclipseNode fieldNode) {
        char[][] newType;
        FieldDeclaration field = (FieldDeclaration)fieldNode.get();
        int pS = source.sourceStart;
        int pE = source.sourceEnd;
        long p = (long)pS << 32 | (long)pE;
        TypeReference rawComponentType = EclipseHandlerUtil.copyType(field.type, source);
        TypeReference boxedComponentType = null;
        boolean isPrimitive = false;
        if (field.type instanceof SingleTypeReference && !(field.type instanceof ArrayTypeReference) && (newType = TYPE_MAP.get(new String(((SingleTypeReference)field.type).token))) != null) {
            boxedComponentType = new QualifiedTypeReference(newType, Eclipse.poss(source, 3));
            isPrimitive = true;
        }
        if (boxedComponentType == null) {
            boxedComponentType = EclipseHandlerUtil.copyType(field.type, source);
        }
        boxedComponentType.sourceStart = pS;
        boxedComponentType.sourceEnd = boxedComponentType.statementEnd = pE;
        Statement[] statements = new Statement[3];
        LocalDeclaration valueDecl = new LocalDeclaration(valueName, pS, pE);
        valueDecl.type = new QualifiedTypeReference(TypeConstants.JAVA_LANG_OBJECT, Eclipse.poss(source, 3));
        valueDecl.type.sourceStart = pS;
        valueDecl.type.sourceEnd = valueDecl.type.statementEnd = pE;
        MessageSend getter = new MessageSend();
        getter.sourceStart = pS;
        getter.statementEnd = getter.sourceEnd = pE;
        getter.selector = new char[]{'g', 'e', 't'};
        getter.receiver = EclipseHandlerUtil.createFieldAccessor(fieldNode, EclipseHandlerUtil.FieldAccess.ALWAYS_FIELD, source);
        valueDecl.initialization = getter;
        statements[0] = valueDecl;
        EqualExpression cond = new EqualExpression((Expression)new SingleNameReference(valueName, p), (Expression)new NullLiteral(pS, pE), 18);
        Block then = new Block(0);
        Expression lock = EclipseHandlerUtil.createFieldAccessor(fieldNode, EclipseHandlerUtil.FieldAccess.ALWAYS_FIELD, source);
        Block inner = new Block(0);
        inner.statements = new Statement[2];
        MessageSend getter2 = new MessageSend();
        getter2.sourceStart = pS;
        getter2.sourceEnd = getter2.statementEnd = pE;
        getter2.selector = new char[]{'g', 'e', 't'};
        getter2.receiver = EclipseHandlerUtil.createFieldAccessor(fieldNode, EclipseHandlerUtil.FieldAccess.ALWAYS_FIELD, source);
        Assignment assign = new Assignment((Expression)new SingleNameReference(valueName, p), (Expression)getter2, pE);
        assign.sourceStart = pS;
        assign.statementEnd = assign.sourceEnd = pE;
        inner.statements[0] = assign;
        EqualExpression innerCond = new EqualExpression((Expression)new SingleNameReference(valueName, p), (Expression)new NullLiteral(pS, pE), 18);
        innerCond.sourceStart = pS;
        innerCond.sourceEnd = innerCond.statementEnd = pE;
        Block innerThen = new Block(0);
        innerThen.statements = new Statement[3];
        LocalDeclaration actualValueDecl = new LocalDeclaration(actualValueName, pS, pE);
        actualValueDecl.type = rawComponentType;
        actualValueDecl.type.sourceStart = pS;
        actualValueDecl.type.sourceEnd = actualValueDecl.type.statementEnd = pE;
        actualValueDecl.initialization = field.initialization;
        actualValueDecl.modifiers = 16;
        innerThen.statements[0] = actualValueDecl;
        if (isPrimitive) {
            Assignment innerAssign = new Assignment((Expression)new SingleNameReference(valueName, p), (Expression)new SingleNameReference(actualValueName, p), pE);
            innerAssign.sourceStart = pS;
            innerAssign.statementEnd = innerAssign.sourceEnd = pE;
            innerThen.statements[1] = innerAssign;
        }
        if (!isPrimitive) {
            EqualExpression avIsNull = new EqualExpression((Expression)new SingleNameReference(actualValueName, p), (Expression)new NullLiteral(pS, pE), 18);
            avIsNull.sourceStart = pS;
            avIsNull.sourceEnd = avIsNull.statementEnd = pE;
            Expression fieldRef = EclipseHandlerUtil.createFieldAccessor(fieldNode, EclipseHandlerUtil.FieldAccess.ALWAYS_FIELD, source);
            ConditionalExpression ternary = new ConditionalExpression((Expression)avIsNull, fieldRef, (Expression)new SingleNameReference(actualValueName, p));
            ternary.sourceStart = pS;
            ternary.sourceEnd = ternary.statementEnd = pE;
            Assignment innerAssign = new Assignment((Expression)new SingleNameReference(valueName, p), (Expression)ternary, pE);
            innerAssign.sourceStart = pS;
            innerAssign.statementEnd = innerAssign.sourceEnd = pE;
            innerThen.statements[1] = innerAssign;
        }
        MessageSend setter = new MessageSend();
        setter.sourceStart = pS;
        setter.sourceEnd = setter.statementEnd = pE;
        setter.receiver = EclipseHandlerUtil.createFieldAccessor(fieldNode, EclipseHandlerUtil.FieldAccess.ALWAYS_FIELD, source);
        setter.selector = new char[]{'s', 'e', 't'};
        setter.arguments = new Expression[]{new SingleNameReference(valueName, p)};
        innerThen.statements[2] = setter;
        IfStatement innerIf = new IfStatement((Expression)innerCond, (Statement)innerThen, pS, pE);
        inner.statements[1] = innerIf;
        SynchronizedStatement sync = new SynchronizedStatement(lock, inner, pS, pE);
        then.statements = new Statement[]{sync};
        IfStatement ifStatement = new IfStatement((Expression)cond, (Statement)then, pS, pE);
        statements[1] = ifStatement;
        if (isPrimitive) {
            CastExpression cast = EclipseHandlerUtil.makeCastExpression((Expression)new SingleNameReference(valueName, p), boxedComponentType, source);
            statements[2] = new ReturnStatement((Expression)cast, pS, pE);
        }
        if (!isPrimitive) {
            EqualExpression vIsThisFieldName = new EqualExpression((Expression)new SingleNameReference(valueName, p), EclipseHandlerUtil.createFieldAccessor(fieldNode, EclipseHandlerUtil.FieldAccess.ALWAYS_FIELD, source), 18);
            vIsThisFieldName.sourceStart = pS;
            vIsThisFieldName.sourceEnd = vIsThisFieldName.statementEnd = pE;
            ConditionalExpression ternary = new ConditionalExpression((Expression)vIsThisFieldName, (Expression)new NullLiteral(pS, pE), (Expression)new SingleNameReference(valueName, p));
            ternary.sourceStart = pS;
            ternary.sourceEnd = ternary.statementEnd = pE;
            ternary.bits |= 0x200000;
            CastExpression cast = EclipseHandlerUtil.makeCastExpression((Expression)ternary, boxedComponentType, source);
            statements[2] = new ReturnStatement((Expression)cast, pS, pE);
        }
        QualifiedTypeReference innerType = new QualifiedTypeReference(TypeConstants.JAVA_LANG_OBJECT, Eclipse.poss(source, 3));
        TypeReference[][] typeParams = new TypeReference[5][];
        typeParams[4] = new TypeReference[]{innerType};
        ParameterizedQualifiedTypeReference type = new ParameterizedQualifiedTypeReference(AR, (TypeReference[][])typeParams, 0, Eclipse.poss(source, 5));
        type.sourceStart = -1;
        type.sourceEnd = -2;
        field.type = type;
        AllocationExpression init = new AllocationExpression();
        init.sourceStart = field.initialization.sourceStart;
        init.sourceEnd = init.statementEnd = field.initialization.sourceEnd;
        init.type = EclipseHandlerUtil.copyType((TypeReference)type, source);
        field.initialization = init;
        return statements;
    }

    static {
        HashMap<String, char[][]> m = new HashMap<String, char[][]>();
        m.put("int", Eclipse.fromQualifiedName("java.lang.Integer"));
        m.put("double", Eclipse.fromQualifiedName("java.lang.Double"));
        m.put("float", Eclipse.fromQualifiedName("java.lang.Float"));
        m.put("short", Eclipse.fromQualifiedName("java.lang.Short"));
        m.put("byte", Eclipse.fromQualifiedName("java.lang.Byte"));
        m.put("long", Eclipse.fromQualifiedName("java.lang.Long"));
        m.put("boolean", Eclipse.fromQualifiedName("java.lang.Boolean"));
        m.put("char", Eclipse.fromQualifiedName("java.lang.Character"));
        TYPE_MAP = Collections.unmodifiableMap(m);
        valueName = "value".toCharArray();
        actualValueName = "actualValue".toCharArray();
    }
}

