/*
 * Decompiled with CFR 0.152.
 */
package org.projectodd.stilts.conduit;

import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.transaction.TransactionManager;
import org.jboss.logging.Logger;
import org.projectodd.stilts.conduit.spi.MessageConduitFactory;
import org.projectodd.stilts.conduit.spi.TransactionalMessageConduitFactory;
import org.projectodd.stilts.conduit.stomp.ConduitStompProvider;
import org.projectodd.stilts.conduit.xa.PseudoXAMessageConduitFactory;
import org.projectodd.stilts.stomp.server.StompServer;
import org.projectodd.stilts.stomp.spi.StompProvider;

public class ConduitServer<T extends MessageConduitFactory> {
    private static Logger log = Logger.getLogger(ConduitServer.class);
    private StompServer<ConduitStompProvider> server;
    private TransactionManager transactionManager;
    private T messageConduitFactory;
    private TransactionalMessageConduitFactory transactionalMessageConduitFactory;

    public ConduitServer() throws UnknownHostException {
        this(8675);
    }

    public ConduitServer(int port) {
        this.server = new StompServer(port);
    }

    public void setPort(int port) {
        this.server.setPort(port);
    }

    public int getPort() {
        return this.server.getPort();
    }

    public void setBindAddress(InetAddress bindAddress) {
        this.server.setBindAddress(bindAddress);
    }

    public InetAddress getBindAddress() {
        return this.server.getBindAddress();
    }

    public void setTransactionManager(TransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public TransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public void setMessageConduitFactory(T messageConduitFactory) {
        this.messageConduitFactory = messageConduitFactory;
        this.transactionalMessageConduitFactory = messageConduitFactory instanceof TransactionalMessageConduitFactory ? (TransactionalMessageConduitFactory)messageConduitFactory : new PseudoXAMessageConduitFactory((MessageConduitFactory)messageConduitFactory);
    }

    public T getMessageConduitFactory() {
        return this.messageConduitFactory;
    }

    public TransactionalMessageConduitFactory getTransactionalMessageConduitFactory() {
        return this.transactionalMessageConduitFactory;
    }

    public void start() throws Exception {
        this.transactionalMessageConduitFactory.setTransactionManager(this.transactionManager);
        ConduitStompProvider provider = new ConduitStompProvider(this.transactionManager, this.getTransactionalMessageConduitFactory());
        this.server.setStompProvider((StompProvider)provider);
        this.server.start();
    }

    public void stop() throws Exception {
        this.server.stop();
    }
}

