/*
 * Decompiled with CFR 0.152.
 */
package org.projectodd.stilts.conduit.stomp;

import java.util.HashSet;
import java.util.Set;
import javax.transaction.TransactionManager;
import org.projectodd.stilts.conduit.spi.TransactionalMessageConduitFactory;
import org.projectodd.stilts.conduit.stomp.ConduitAcknowledgeableMessageSink;
import org.projectodd.stilts.conduit.stomp.ConduitStompConnection;
import org.projectodd.stilts.stomp.Headers;
import org.projectodd.stilts.stomp.Heartbeat;
import org.projectodd.stilts.stomp.StompException;
import org.projectodd.stilts.stomp.protocol.StompFrame;
import org.projectodd.stilts.stomp.server.helpers.OpenAuthenticator;
import org.projectodd.stilts.stomp.spi.AcknowledgeableMessageSink;
import org.projectodd.stilts.stomp.spi.Authenticator;
import org.projectodd.stilts.stomp.spi.StompConnection;
import org.projectodd.stilts.stomp.spi.StompProvider;
import org.projectodd.stilts.stomp.spi.TransactionalAcknowledgeableMessageSink;

public class ConduitStompProvider
implements StompProvider {
    private TransactionalMessageConduitFactory messageConduitFactory;
    private TransactionManager transactionManager;
    private Authenticator authenticator;
    private Set<ConduitStompConnection> connections = new HashSet<ConduitStompConnection>();

    public ConduitStompProvider(TransactionManager transactionManager, TransactionalMessageConduitFactory messageConduitFactory) {
        this(transactionManager, messageConduitFactory, null);
    }

    public ConduitStompProvider(TransactionManager transactionManager, TransactionalMessageConduitFactory messageConduitFactory, Authenticator authenticator) {
        this.transactionManager = transactionManager;
        if (authenticator == null) {
            authenticator = OpenAuthenticator.INSTANCE;
        }
        this.authenticator = authenticator;
        this.messageConduitFactory = messageConduitFactory;
    }

    public Authenticator getAuthenticator() {
        return this.authenticator;
    }

    public TransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StompConnection createConnection(TransactionalAcknowledgeableMessageSink messageSink, Headers headers, StompFrame.Version version, Heartbeat hb) throws StompException {
        if (this.authenticator.authenticate(headers)) {
            try {
                ConduitStompConnection connection = this.createStompConnection(messageSink, headers, version, hb);
                Set<ConduitStompConnection> set = this.connections;
                synchronized (set) {
                    this.connections.add(connection);
                }
                return connection;
            }
            catch (Exception e) {
                throw new StompException((Throwable)e);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws Exception {
        HashSet<ConduitStompConnection> disconnecting = new HashSet<ConduitStompConnection>();
        Set<ConduitStompConnection> set = this.connections;
        synchronized (set) {
            disconnecting.addAll(this.connections);
        }
        for (ConduitStompConnection each : disconnecting) {
            each.disconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unregister(ConduitStompConnection circusStompConnection) {
        Set<ConduitStompConnection> set = this.connections;
        synchronized (set) {
            this.connections.remove(circusStompConnection);
        }
    }

    protected ConduitStompConnection createStompConnection(TransactionalAcknowledgeableMessageSink messageSink, Headers headers, StompFrame.Version version, Heartbeat hb) throws Exception {
        ConduitAcknowledgeableMessageSink conduitSink = new ConduitAcknowledgeableMessageSink(messageSink);
        ConduitStompConnection connection = new ConduitStompConnection(this, this.messageConduitFactory.createMessageConduit((AcknowledgeableMessageSink)conduitSink, headers), version, hb);
        conduitSink.setConnection(connection);
        return connection;
    }

    TransactionalMessageConduitFactory getMessageConduitFactory() {
        return this.messageConduitFactory;
    }
}

