/*
 * Decompiled with CFR 0.152.
 */
package org.projectodd.stilts.conduit.stomp;

import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.jboss.logging.Logger;
import org.projectodd.stilts.conduit.stomp.ConduitStompConnection;
import org.projectodd.stilts.stomp.Acknowledger;
import org.projectodd.stilts.stomp.StompException;
import org.projectodd.stilts.stomp.StompMessage;
import org.projectodd.stilts.stomp.spi.StompTransaction;

public class ConduitStompTransaction
implements StompTransaction {
    private static final Logger log = Logger.getLogger(ConduitStompTransaction.class);
    private Transaction transaction;
    private ConduitStompConnection stompConnection;
    private String id;

    public ConduitStompTransaction(ConduitStompConnection clientAgent, Transaction transaction, String id) {
        this.stompConnection = clientAgent;
        this.transaction = transaction;
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public ConduitStompConnection getStompConnection() {
        return this.stompConnection;
    }

    public Transaction getJTATransaction() {
        return this.transaction;
    }

    public void commit() throws StompException {
        try {
            log.debugf("Committing transaction", new Object[0]);
            TransactionManager tm = this.stompConnection.getStompProvider().getTransactionManager();
            tm.resume(this.transaction);
            tm.commit();
        }
        catch (SecurityException e) {
            throw new StompException((Throwable)e);
        }
        catch (IllegalStateException e) {
            throw new StompException((Throwable)e);
        }
        catch (RollbackException e) {
            throw new StompException((Throwable)e);
        }
        catch (HeuristicMixedException e) {
            throw new StompException((Throwable)e);
        }
        catch (HeuristicRollbackException e) {
            throw new StompException((Throwable)e);
        }
        catch (SystemException e) {
            throw new StompException((Throwable)e);
        }
        catch (InvalidTransactionException e) {
            throw new StompException((Throwable)e);
        }
    }

    public void abort() throws StompException {
        try {
            log.debugf("Aborting transaction", new Object[0]);
            TransactionManager tm = this.stompConnection.getStompProvider().getTransactionManager();
            tm.resume(this.transaction);
            tm.rollback();
        }
        catch (IllegalStateException e) {
            throw new StompException((Throwable)e);
        }
        catch (SystemException e) {
            throw new StompException((Throwable)e);
        }
        catch (InvalidTransactionException e) {
            throw new StompException((Throwable)e);
        }
    }

    public void send(StompMessage message) throws StompException {
        try {
            TransactionManager tm = this.stompConnection.getStompProvider().getTransactionManager();
            tm.resume(this.transaction);
            message.getHeaders().remove("transaction");
            this.stompConnection.send(message);
            tm.suspend();
        }
        catch (StompException e) {
            throw e;
        }
        catch (Exception e) {
            throw new StompException((Throwable)e);
        }
    }

    public void ack(Acknowledger acknowledger) throws StompException {
        try {
            TransactionManager tm = this.stompConnection.getStompProvider().getTransactionManager();
            tm.resume(this.transaction);
            acknowledger.ack();
            tm.suspend();
        }
        catch (Exception e) {
            throw new StompException((Throwable)e);
        }
    }

    public void nack(Acknowledger acknowledger) throws StompException {
        try {
            TransactionManager tm = this.stompConnection.getStompProvider().getTransactionManager();
            tm.resume(this.transaction);
            acknowledger.nack();
            tm.suspend();
        }
        catch (Exception e) {
            throw new StompException((Throwable)e);
        }
    }

    public String toString() {
        return "[" + this.getClass().getSimpleName() + ": " + this.id + "]";
    }
}

