/*
 * Decompiled with CFR 0.152.
 */
package org.projectodd.stilts.conduit.xa;

import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAResource;
import org.jboss.logging.Logger;
import org.projectodd.stilts.conduit.spi.MessageConduit;
import org.projectodd.stilts.conduit.xa.PseudoXAResourceManager;
import org.projectodd.stilts.conduit.xa.PseudoXATransaction;
import org.projectodd.stilts.stomp.Headers;
import org.projectodd.stilts.stomp.StompMessage;
import org.projectodd.stilts.stomp.Subscription;
import org.projectodd.stilts.stomp.spi.StompSession;

public class PseudoXAMessageConduit
implements MessageConduit {
    private static Logger log = Logger.getLogger(PseudoXAMessageConduit.class);
    private TransactionManager transactionManager;
    private PseudoXAResourceManager resourceManager;

    public PseudoXAMessageConduit(TransactionManager transactionManager, PseudoXAResourceManager resourceManager) {
        this.transactionManager = transactionManager;
        this.resourceManager = resourceManager;
    }

    public StompSession getSession() {
        return this.resourceManager.getMessageConduit().getSession();
    }

    public void send(StompMessage stompMessage) throws Exception {
        Transaction jtaTransaction = this.transactionManager.getTransaction();
        if (jtaTransaction != null) {
            jtaTransaction.enlistResource((XAResource)this.resourceManager);
            PseudoXATransaction tx = this.resourceManager.currentTransaction();
            tx.addSentMessage(stompMessage);
        } else {
            log.debugf("NO TX, forward SEND", new Object[0]);
            this.resourceManager.getMessageConduit().send(stompMessage);
        }
    }

    public Subscription subscribe(String subscriptionId, String destination, Headers headers) throws Exception {
        return this.resourceManager.getMessageConduit().subscribe(subscriptionId, destination, headers);
    }
}

