/*
 * Decompiled with CFR 0.152.
 */
package org.projectodd.stilts.conduit.xa;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.projectodd.stilts.conduit.spi.MessageConduit;
import org.projectodd.stilts.conduit.xa.PseudoXATransaction;

public class PseudoXAResourceManager
implements XAResource {
    private final ThreadLocal<PseudoXATransaction> currentTransaction = new ThreadLocal();
    private final Map<Xid, PseudoXATransaction> transactions = new ConcurrentHashMap<Xid, PseudoXATransaction>();
    private MessageConduit messageConduit;
    private int transactionTimeout;

    public PseudoXAResourceManager(MessageConduit messageConduit) {
        this.messageConduit = messageConduit;
    }

    public MessageConduit getMessageConduit() {
        return this.messageConduit;
    }

    @Override
    public boolean setTransactionTimeout(int seconds) throws XAException {
        this.transactionTimeout = seconds;
        return true;
    }

    @Override
    public int getTransactionTimeout() throws XAException {
        return this.transactionTimeout;
    }

    @Override
    public void start(Xid xid, int flags) throws XAException {
        PseudoXATransaction tx = null;
        if (flags == 0 || flags == 0x200000) {
            tx = new PseudoXATransaction();
            this.transactions.put(xid, tx);
        } else if (flags == 0x8000000) {
            tx = this.transactions.get(xid);
        }
        if (tx == null) {
            throw new XAException("Unable to start transaction: " + xid);
        }
        this.currentTransaction.set(tx);
    }

    @Override
    public void end(Xid xid, int flags) throws XAException {
        PseudoXATransaction tx = this.transactions.get(xid);
        if (tx == null) {
            throw new XAException("No such transaction: " + xid);
        }
        if (flags == 0x20000000) {
            tx.setRollbackOnly(true);
        }
        this.currentTransaction.remove();
    }

    @Override
    public int prepare(Xid xid) throws XAException {
        PseudoXATransaction tx = this.transactions.get(xid);
        if (tx == null) {
            throw new XAException("No such transaction: " + xid);
        }
        if (tx.isRollbackOnly()) {
            throw new XAException(100);
        }
        return 0;
    }

    @Override
    public void commit(Xid xid, boolean onePhase) throws XAException {
        PseudoXATransaction tx = this.transactions.get(xid);
        if (tx == null) {
            throw new XAException("No such transaction: " + xid);
        }
        tx.commit(this.messageConduit);
    }

    @Override
    public void rollback(Xid xid) throws XAException {
        PseudoXATransaction tx = this.transactions.get(xid);
        if (tx == null) {
            throw new XAException("No such transaction: " + xid);
        }
        tx.rollback(this.messageConduit);
    }

    @Override
    public void forget(Xid xid) throws XAException {
    }

    @Override
    public boolean isSameRM(XAResource xares) throws XAException {
        return false;
    }

    @Override
    public Xid[] recover(int flag) throws XAException {
        return null;
    }

    PseudoXATransaction currentTransaction() {
        return this.currentTransaction.get();
    }
}

