/*
 * Decompiled with CFR 0.152.
 */
package org.projectodd.stilts.stomp.protocol;

import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.projectodd.stilts.stomp.Headers;
import org.projectodd.stilts.stomp.StompMessage;
import org.projectodd.stilts.stomp.protocol.StompContentFrame;
import org.projectodd.stilts.stomp.protocol.StompControlFrame;
import org.projectodd.stilts.stomp.protocol.StompFrame;

public class StompFrames {
    public static StompFrame newAckFrame(Headers headers) {
        StompControlFrame frame = new StompControlFrame(StompFrame.Command.ACK);
        frame.setHeader("message-id", headers.get("message-id"));
        frame.setHeader("subscription", headers.get("subscription"));
        String transactionId = headers.get("transaction");
        if (transactionId != null) {
            frame.setHeader("transaction", transactionId);
        }
        return frame;
    }

    public static StompFrame newNackFrame(Headers headers) {
        StompControlFrame frame = new StompControlFrame(StompFrame.Command.NACK);
        frame.setHeader("message-id", headers.get("message-id"));
        frame.setHeader("subscription", headers.get("subscription"));
        String transactionId = headers.get("transaction");
        if (transactionId != null) {
            frame.setHeader("transaction", transactionId);
        }
        return frame;
    }

    public static StompFrame newSendFrame(StompMessage message) {
        StompContentFrame frame = new StompContentFrame(StompFrame.Command.SEND, message.getHeaders());
        frame.setContent(ChannelBuffers.copiedBuffer((ChannelBuffer)message.getContent()));
        return frame;
    }

    public static StompFrame newConnectedFrame(String sessionId, StompFrame.Version version) {
        StompControlFrame frame = new StompControlFrame(StompFrame.Command.CONNECTED);
        frame.setHeader("session", sessionId);
        String implVersion = StompFrames.class.getPackage().getImplementationVersion();
        frame.setHeader("server", "Stilts/" + implVersion);
        if (version.isAfter(StompFrame.Version.VERSION_1_0)) {
            frame.setHeader("version", version.versionString());
        }
        return frame;
    }

    public static StompFrame newDisconnectFrame() {
        StompControlFrame frame = new StompControlFrame(StompFrame.Command.DISCONNECT);
        frame.setHeader("receipt", "connection-close");
        return frame;
    }

    public static StompFrame newErrorFrame(String message, StompFrame inReplyTo) {
        String receiptId;
        StompContentFrame frame = new StompContentFrame(StompFrame.Command.ERROR);
        if (inReplyTo != null && (receiptId = inReplyTo.getHeader("receipt")) != null) {
            frame.setHeader("receipt-id", receiptId);
        }
        byte[] bytes = message.getBytes();
        frame.setContent(ChannelBuffers.copiedBuffer((byte[])bytes));
        frame.setHeader("content-length", String.valueOf(bytes.length));
        frame.setHeader("content-type", "text/plain");
        return frame;
    }

    public static StompFrame newReceiptFrame(String receiptId) {
        StompControlFrame receipt = new StompControlFrame(StompFrame.Command.RECEIPT);
        receipt.setHeader("receipt-id", receiptId);
        return receipt;
    }

    public static StompControlFrame newBeginFrame(String transactionId) {
        StompControlFrame frame = new StompControlFrame(StompFrame.Command.BEGIN);
        frame.setHeader("transaction", transactionId);
        return frame;
    }

    public static StompControlFrame newCommitFrame(String transactionId) {
        StompControlFrame frame = new StompControlFrame(StompFrame.Command.COMMIT);
        frame.setHeader("transaction", transactionId);
        return frame;
    }

    public static StompControlFrame newAbortFrame(String transactionId) {
        StompControlFrame frame = new StompControlFrame(StompFrame.Command.ABORT);
        frame.setHeader("transaction", transactionId);
        return frame;
    }
}

