/*
 * Decompiled with CFR 0.152.
 */
package org.projectodd.stilts.stomp.protocol.websocket.ietf00;

import java.net.URI;
import java.security.NoSuchAlgorithmException;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.handler.codec.http.DefaultHttpRequest;
import org.jboss.netty.handler.codec.http.DefaultHttpResponse;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.handler.codec.http.HttpResponse;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.jboss.netty.handler.codec.http.HttpVersion;
import org.projectodd.stilts.stomp.protocol.websocket.Handshake;
import org.projectodd.stilts.stomp.protocol.websocket.ietf00.Ietf00WebSocketChallenge;
import org.projectodd.stilts.stomp.protocol.websocket.ietf00.Ietf00WebSocketFrameDecoder;
import org.projectodd.stilts.stomp.protocol.websocket.ietf00.Ietf00WebSocketFrameEncoder;

public class Ietf00Handshake
extends Handshake {
    private static final ChannelHandler[] EMPTY_HANDLER_ARRAY = new ChannelHandler[0];
    private Ietf00WebSocketChallenge challenge = new Ietf00WebSocketChallenge();

    public Ietf00Handshake() throws NoSuchAlgorithmException {
        super("0");
    }

    @Override
    public boolean matches(HttpRequest request) {
        return request.containsHeader("Sec-WebSocket-Key1") && request.containsHeader("Sec-WebSocket-Key2");
    }

    @Override
    public HttpRequest generateRequest(URI uri) throws Exception {
        DefaultHttpRequest request = new DefaultHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, uri.toString());
        request.addHeader("Connection", (Object)"Upgrade");
        request.addHeader("Upgrade", (Object)"WebSocket");
        request.addHeader("Host", (Object)(uri.getHost() + ":" + uri.getPort()));
        request.addHeader("Sec-WebSocket-Protocol", (Object)"stomp");
        request.addHeader("Sec-WebSocket-Key1", (Object)this.challenge.getKey1String());
        request.addHeader("Sec-WebSocket-Key2", (Object)this.challenge.getKey2String());
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer((int)6);
        buffer.writeBytes(this.challenge.getKey3());
        buffer.writeByte(13);
        buffer.writeByte(10);
        request.setContent(buffer);
        return request;
    }

    @Override
    public HttpResponse generateResponse(HttpRequest request) throws Exception {
        DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, new HttpResponseStatus(101, "Web Socket Protocol Handshake - IETF-00"));
        String origin = request.getHeader("Origin");
        if (origin != null) {
            response.addHeader("Sec-WebSocket-Origin", (Object)request.getHeader("Origin"));
        }
        response.addHeader("Sec-WebSocket-Location", (Object)this.getWebSocketLocation(request));
        String protocol = request.getHeader("Sec-WebSocket-Protocol");
        if (protocol != null) {
            response.addHeader("Sec-WebSocket-Protocol", (Object)protocol);
        }
        String key1 = request.getHeader("Sec-WebSocket-Key1");
        String key2 = request.getHeader("Sec-WebSocket-Key2");
        byte[] key3 = new byte[8];
        request.getContent().readBytes(key3);
        byte[] solution = Ietf00WebSocketChallenge.solve(key1, key2, key3);
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer((int)(solution.length + 2));
        buffer.writeBytes(solution);
        response.setContent(buffer);
        response.setChunked(false);
        return response;
    }

    @Override
    public boolean isComplete(HttpResponse response) throws Exception {
        ChannelBuffer content = response.getContent();
        byte[] challengeResponse = new byte[16];
        content.readBytes(challengeResponse);
        return this.challenge.verify(challengeResponse);
    }

    @Override
    public ChannelHandler newEncoder() {
        return new Ietf00WebSocketFrameEncoder();
    }

    @Override
    public ChannelHandler newDecoder() {
        return new Ietf00WebSocketFrameDecoder();
    }

    @Override
    public ChannelHandler[] newAdditionalHandlers() {
        return EMPTY_HANDLER_ARRAY;
    }

    @Override
    public int readResponseBody() {
        return 16;
    }
}

