/*
 * Decompiled with CFR 0.152.
 */
package org.projectodd.stilts.stomp.protocol.websocket.ietf07;

import org.jboss.logging.Logger;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.handler.codec.frame.TooLongFrameException;
import org.jboss.netty.handler.codec.replay.ReplayingDecoder;
import org.jboss.netty.handler.codec.replay.VoidEnum;
import org.projectodd.stilts.stomp.protocol.websocket.DefaultWebSocketFrame;
import org.projectodd.stilts.stomp.protocol.websocket.WebSocketFrame;

public class Ietf07WebSocketFrameDecoder
extends ReplayingDecoder<VoidEnum> {
    public static final int DEFAULT_MAX_FRAME_SIZE = 16384;
    private final int maxFrameSize;
    private static final Logger log = Logger.getLogger(Ietf07WebSocketFrameDecoder.class);

    public Ietf07WebSocketFrameDecoder() {
        this(16384);
    }

    public Ietf07WebSocketFrameDecoder(int maxFrameSize) {
        this.maxFrameSize = maxFrameSize;
    }

    protected Object decode(ChannelHandlerContext ctx, Channel channel, ChannelBuffer buffer, VoidEnum state) throws Exception {
        byte finOpcode = buffer.readByte();
        boolean fin = (finOpcode & 1) != 0;
        int opcode = finOpcode >> 4 & 0xF;
        byte lengthMask = buffer.readByte();
        boolean masked = (lengthMask & 0x80) != 0;
        long length = lengthMask & 0x7F;
        if (length == 126L) {
            length = buffer.readShort();
        } else if (length == 127L) {
            length = buffer.readLong();
        }
        if (length > (long)this.maxFrameSize) {
            throw new TooLongFrameException();
        }
        byte[] mask = null;
        if (masked) {
            mask = new byte[4];
            buffer.readBytes(mask);
        }
        byte[] payload = new byte[(int)length];
        buffer.readBytes(payload);
        if (masked) {
            for (int i = 0; i < payload.length; ++i) {
                payload[i] = (byte)(payload[i] ^ mask[i % 4]);
            }
        }
        ChannelBuffer data = ChannelBuffers.wrappedBuffer((byte[])payload);
        WebSocketFrame.FrameType frameType = this.decodeFrameType(opcode);
        return new DefaultWebSocketFrame(frameType, data);
    }

    protected WebSocketFrame.FrameType decodeFrameType(int opcode) {
        switch (opcode) {
            case 0: {
                return WebSocketFrame.FrameType.CONTINUATION;
            }
            case 1: {
                return WebSocketFrame.FrameType.TEXT;
            }
            case 2: {
                return WebSocketFrame.FrameType.BINARY;
            }
            case 8: {
                return WebSocketFrame.FrameType.CLOSE;
            }
            case 9: {
                return WebSocketFrame.FrameType.PING;
            }
            case 10: {
                return WebSocketFrame.FrameType.PONG;
            }
        }
        return null;
    }
}

