/*
 * Decompiled with CFR 0.152.
 */
package org.projectodd.stilts.stomp.server;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.jboss.netty.bootstrap.ServerBootstrap;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.socket.ServerSocketChannelFactory;
import org.jboss.netty.channel.socket.nio.NioServerSocketChannelFactory;
import org.jboss.netty.util.VirtualExecutorService;
import org.projectodd.stilts.stomp.server.protocol.StompServerPipelineFactory;
import org.projectodd.stilts.stomp.spi.StompProvider;

public class StompServer<T extends StompProvider> {
    public static final int DEFAULT_PORT = 8675;
    private int port;
    private T stompProvider;
    private Executor channelExecutor;
    private ChannelPipelineFactory channelPipelineFactory;
    private Executor messageHandlingExecutor;
    private Channel channel;

    public StompServer() {
        this(8675);
    }

    public StompServer(int port) {
        this.port = port;
    }

    public int getPort() {
        return this.port;
    }

    public void setChannelExecutor(Executor executor) {
        this.channelExecutor = executor;
    }

    public Executor getChannelExecutor() {
        return this.channelExecutor;
    }

    public void setMessageHandlingExecutor(Executor executor) {
        this.messageHandlingExecutor = executor;
    }

    public Executor getMessageHandlingExector() {
        return this.messageHandlingExecutor;
    }

    public void setStompProvider(T stompProvider) {
        this.stompProvider = stompProvider;
    }

    public T getStompProvider() {
        return this.stompProvider;
    }

    public void start() throws Exception {
        if (this.channelExecutor == null) {
            this.channelExecutor = Executors.newFixedThreadPool(10);
        }
        if (this.channelPipelineFactory == null) {
            this.channelPipelineFactory = new StompServerPipelineFactory((StompProvider)this.getStompProvider(), this.getMessageHandlingExector());
        }
        ServerBootstrap bootstrap = this.createServerBootstrap();
        this.channel = bootstrap.bind((SocketAddress)new InetSocketAddress(this.port));
    }

    protected ServerBootstrap createServerBootstrap() throws Exception {
        ServerBootstrap bootstrap = new ServerBootstrap((ChannelFactory)this.createChannelFactory());
        bootstrap.setOption("reuseAddress", (Object)true);
        bootstrap.setPipelineFactory(this.getChannelPipelineFactory());
        return bootstrap;
    }

    protected void setChannelPipelineFactory(ChannelPipelineFactory channelPipelineFactory) {
        this.channelPipelineFactory = channelPipelineFactory;
    }

    protected ChannelPipelineFactory getChannelPipelineFactory() {
        return this.channelPipelineFactory;
    }

    protected ServerSocketChannelFactory createChannelFactory() {
        VirtualExecutorService bossExecutor = new VirtualExecutorService(this.channelExecutor);
        VirtualExecutorService workerExecutor = new VirtualExecutorService(this.channelExecutor);
        return new NioServerSocketChannelFactory((Executor)bossExecutor, (Executor)workerExecutor);
    }

    public void stop() throws Exception {
        this.channel.close();
        this.channel = null;
    }
}

