/*
 * Decompiled with CFR 0.152.
 */
package org.projectodd.stilts.stomp.server.protocol;

import org.jboss.logging.Logger;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.MessageEvent;
import org.projectodd.stilts.stomp.Heartbeat;
import org.projectodd.stilts.stomp.protocol.StompFrame;
import org.projectodd.stilts.stomp.server.protocol.AbstractProviderHandler;
import org.projectodd.stilts.stomp.server.protocol.ConnectionContext;
import org.projectodd.stilts.stomp.spi.StompConnection;
import org.projectodd.stilts.stomp.spi.StompProvider;

public abstract class AbstractControlFrameHandler
extends AbstractProviderHandler {
    private static final Logger log = Logger.getLogger(AbstractControlFrameHandler.class);
    private StompFrame.Command command;
    private boolean requiresClientIdentification = true;

    public AbstractControlFrameHandler(StompProvider provider, ConnectionContext context, StompFrame.Command command) {
        super(provider, context);
        this.command = command;
    }

    public void messageReceived(ChannelHandlerContext channelContext, MessageEvent e) throws Exception {
        Heartbeat hb;
        StompConnection connection;
        if (e.getMessage() instanceof StompFrame) {
            this.handleStompFrame(channelContext, (StompFrame)e.getMessage());
        }
        if ((connection = this.getStompConnection()) != null && (hb = connection.getHeartbeat()) != null) {
            hb.touch();
        }
        super.messageReceived(channelContext, e);
    }

    protected void handleStompFrame(ChannelHandlerContext channelContext, StompFrame frame) {
        if (!frame.getCommand().equals((Object)this.command)) {
            return;
        }
        if (this.requiresClientIdentification && this.getContext().getStompConnection() == null) {
            log.warn((Object)"Client not CONNECTED, closing connection");
            this.sendErrorAndClose(channelContext, "Must CONNECT first", frame);
            return;
        }
        this.handleControlFrame(channelContext, frame);
    }

    protected void setRequiresClientIdentification(boolean requiresClientIdentification) {
        this.requiresClientIdentification = requiresClientIdentification;
    }

    public abstract void handleControlFrame(ChannelHandlerContext var1, StompFrame var2);
}

