/*
 * Decompiled with CFR 0.152.
 */
package org.projectodd.stilts.stomp.server.protocol;

import org.jboss.logging.Logger;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.projectodd.stilts.stomp.protocol.StompFrame;
import org.projectodd.stilts.stomp.protocol.StompFrames;
import org.projectodd.stilts.stomp.server.protocol.ConnectionContext;
import org.projectodd.stilts.stomp.spi.StompConnection;
import org.projectodd.stilts.stomp.spi.StompProvider;

public abstract class AbstractProviderHandler
extends SimpleChannelUpstreamHandler {
    private static Logger log = Logger.getLogger(AbstractProviderHandler.class);
    private StompProvider provider;
    private ConnectionContext context;

    public AbstractProviderHandler(StompProvider provider, ConnectionContext context) {
        this.provider = provider;
        this.context = context;
    }

    public StompProvider getStompProvider() {
        return this.provider;
    }

    public ConnectionContext getContext() {
        return this.context;
    }

    public StompConnection getStompConnection() {
        return this.context.getStompConnection();
    }

    protected ChannelFuture sendFrame(ChannelHandlerContext channelContext, StompFrame frame) {
        return channelContext.getChannel().write((Object)frame);
    }

    protected ChannelFuture sendError(ChannelHandlerContext channelContext, String message, StompFrame inReplyTo) {
        return this.sendFrame(channelContext, StompFrames.newErrorFrame((String)message, (StompFrame)inReplyTo));
    }

    protected void sendErrorAndClose(ChannelHandlerContext channelContext, String message, StompFrame inReplyTo) {
        this.getContext().setActive(false);
        ChannelFuture future = this.sendError(channelContext, message, inReplyTo);
        future.addListener(ChannelFutureListener.CLOSE);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
        log.error((Object)"An error occurred", e.getCause());
    }
}

