/*
 * Decompiled with CFR 0.152.
 */
package org.projectodd.stilts.stomp.server.protocol;

import org.jboss.logging.Logger;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.projectodd.stilts.stomp.TransactionalAcknowledger;
import org.projectodd.stilts.stomp.protocol.StompFrame;
import org.projectodd.stilts.stomp.server.protocol.AbstractControlFrameHandler;
import org.projectodd.stilts.stomp.server.protocol.ConnectionContext;
import org.projectodd.stilts.stomp.spi.StompProvider;

public class AckHandler
extends AbstractControlFrameHandler {
    private static final Logger log = Logger.getLogger(AckHandler.class);

    public AckHandler(StompProvider provider, ConnectionContext context) {
        super(provider, context, StompFrame.Command.ACK);
    }

    @Override
    public void handleControlFrame(ChannelHandlerContext channelContext, StompFrame frame) {
        String messageId = frame.getHeader("message-id");
        TransactionalAcknowledger acknowledger = this.getContext().getAckManager().removeAcknowledger(messageId);
        if (acknowledger != null) {
            String transactionId = frame.getHeader("transaction");
            try {
                acknowledger.ack(transactionId);
            }
            catch (Exception e) {
                log.errorf((Throwable)e, "Cannot ack frame: %s", (Object)frame);
                this.sendError(channelContext, "Unable to ACK", frame);
            }
        }
    }
}

