/*
 * Decompiled with CFR 0.152.
 */
package org.projectodd.stilts.stomp.server.protocol;

import org.apache.commons.lang.StringUtils;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.projectodd.stilts.stomp.StompException;
import org.projectodd.stilts.stomp.protocol.StompFrame;
import org.projectodd.stilts.stomp.server.protocol.AbstractControlFrameHandler;
import org.projectodd.stilts.stomp.server.protocol.ConnectionContext;
import org.projectodd.stilts.stomp.spi.StompProvider;

public class BeginHandler
extends AbstractControlFrameHandler {
    public BeginHandler(StompProvider server, ConnectionContext context) {
        super(server, context, StompFrame.Command.BEGIN);
    }

    @Override
    public void handleControlFrame(ChannelHandlerContext channelContext, StompFrame frame) {
        try {
            String transactionId = frame.getHeader("transaction");
            if (StringUtils.isEmpty((String)transactionId)) {
                throw new StompException("No transaction ID supplied.");
            }
            this.getStompConnection().begin(transactionId, frame.getHeaders());
        }
        catch (StompException e) {
            this.sendError(channelContext, "Unable to begin transaction: " + e.getMessage(), frame);
        }
    }
}

