/*
 * Decompiled with CFR 0.152.
 */
package org.projectodd.stilts.stomp.server.protocol;

import org.jboss.logging.Logger;
import org.projectodd.stilts.stomp.Heartbeat;
import org.projectodd.stilts.stomp.StompException;
import org.projectodd.stilts.stomp.StompMessage;
import org.projectodd.stilts.stomp.StompMessages;
import org.projectodd.stilts.stomp.spi.StompConnection;

public class HeartbeatRunnable
implements Runnable {
    private static final double TOLERANCE_PERCENTAGE = 0.05;
    private static final Logger log = Logger.getLogger(HeartbeatRunnable.class);
    private Heartbeat heartbeat;
    private int duration;
    private StompConnection connection;

    public HeartbeatRunnable(Heartbeat hb, StompConnection connection) {
        this.heartbeat = hb;
        this.duration = this.heartbeat.calculateDuration(hb.getServerSend(), hb.getClientReceive());
        this.connection = connection;
    }

    @Override
    public void run() {
        long diff = System.currentTimeMillis() - this.heartbeat.getLastUpdate();
        double tolerance = (double)this.duration * 0.05;
        log.debug((Object)("HEARTBEAT : " + diff + " / " + this.duration));
        if ((double)diff > (double)this.duration - tolerance) {
            StompMessage msg = StompMessages.createStompMessage();
            try {
                this.connection.send(msg, null);
                this.heartbeat.touch();
            }
            catch (StompException e) {
                log.error((Object)"Could not send heartbeat message:", (Throwable)e);
            }
        }
    }
}

