/*
 * Decompiled with CFR 0.152.
 */
package org.projectodd.stilts.stomp.server.protocol;

import org.apache.commons.lang.StringUtils;
import org.jboss.logging.Logger;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.projectodd.stilts.stomp.StompException;
import org.projectodd.stilts.stomp.TransactionalAcknowledger;
import org.projectodd.stilts.stomp.protocol.StompFrame;
import org.projectodd.stilts.stomp.server.protocol.AbstractControlFrameHandler;
import org.projectodd.stilts.stomp.server.protocol.ConnectionContext;
import org.projectodd.stilts.stomp.spi.StompProvider;

public class NackHandler
extends AbstractControlFrameHandler {
    private static Logger log = Logger.getLogger(NackHandler.class);

    public NackHandler(StompProvider server, ConnectionContext context) {
        super(server, context, StompFrame.Command.NACK);
    }

    @Override
    public void handleControlFrame(ChannelHandlerContext channelContext, StompFrame frame) {
        try {
            StompFrame.Version version = this.getContext().getStompConnection().getVersion();
            if (version.isBefore(StompFrame.Version.VERSION_1_1)) {
                throw new StompException("NACK unsupported prior to STOMP 1.1.");
            }
            String messageId = frame.getHeader("message-id");
            if (StringUtils.isEmpty((String)messageId)) {
                throw new StompException("Cannot NACK without message ID.");
            }
            String subscription = frame.getHeader("subscription");
            if (StringUtils.isEmpty((String)subscription)) {
                throw new StompException("Cannot NACK without subscription ID.");
            }
            TransactionalAcknowledger acknowledger = this.getContext().getAckManager().removeAcknowledger(messageId);
            if (acknowledger == null) {
                log.warn((Object)("Attempting to NACK non-existent message ID: " + messageId));
            } else {
                String transactionId = frame.getHeader("transaction");
                acknowledger.nack(transactionId);
            }
        }
        catch (StompException e) {
            this.sendError(channelContext, e.getMessage(), frame);
        }
        catch (Exception e) {
            this.sendError(channelContext, "Unable to NACK", frame);
        }
    }
}

