/*
 * Decompiled with CFR 0.152.
 */
package org.projectodd.stilts.stomp.server.protocol;

import java.nio.charset.Charset;
import java.security.NoSuchAlgorithmException;
import java.util.concurrent.Executor;
import org.jboss.logging.Logger;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.UpstreamMessageEvent;
import org.jboss.netty.handler.codec.http.HttpRequestDecoder;
import org.jboss.netty.handler.codec.http.HttpResponseEncoder;
import org.jboss.netty.handler.codec.replay.ReplayingDecoder;
import org.jboss.netty.handler.codec.replay.VoidEnum;
import org.jboss.netty.handler.execution.ExecutionHandler;
import org.projectodd.stilts.stomp.StompMessageFactory;
import org.projectodd.stilts.stomp.protocol.StompFrameDecoder;
import org.projectodd.stilts.stomp.protocol.StompFrameEncoder;
import org.projectodd.stilts.stomp.protocol.StompMessageDecoder;
import org.projectodd.stilts.stomp.protocol.StompMessageEncoder;
import org.projectodd.stilts.stomp.protocol.websocket.WebSocketStompFrameDecoder;
import org.projectodd.stilts.stomp.protocol.websocket.WebSocketStompFrameEncoder;
import org.projectodd.stilts.stomp.server.ServerStompMessageFactory;
import org.projectodd.stilts.stomp.server.protocol.AbortHandler;
import org.projectodd.stilts.stomp.server.protocol.AckHandler;
import org.projectodd.stilts.stomp.server.protocol.BeginHandler;
import org.projectodd.stilts.stomp.server.protocol.CommitHandler;
import org.projectodd.stilts.stomp.server.protocol.ConnectHandler;
import org.projectodd.stilts.stomp.server.protocol.ConnectionContext;
import org.projectodd.stilts.stomp.server.protocol.DisconnectHandler;
import org.projectodd.stilts.stomp.server.protocol.NackHandler;
import org.projectodd.stilts.stomp.server.protocol.ReceiptHandler;
import org.projectodd.stilts.stomp.server.protocol.SendHandler;
import org.projectodd.stilts.stomp.server.protocol.StompDisorderlyCloseHandler;
import org.projectodd.stilts.stomp.server.protocol.SubscribeHandler;
import org.projectodd.stilts.stomp.server.protocol.UnsubscribeHandler;
import org.projectodd.stilts.stomp.server.websockets.protocol.DisorderlyCloseHandler;
import org.projectodd.stilts.stomp.server.websockets.protocol.ServerHandshakeHandler;
import org.projectodd.stilts.stomp.spi.StompProvider;

public class ProtocolDetector
extends ReplayingDecoder<VoidEnum> {
    private static final Logger log = Logger.getLogger((String)"org.projectodd.stilts.stomp.server.protocol");
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private StompProvider provider;
    private Executor executor;
    private ExecutionHandler executionHandler;

    public ProtocolDetector(StompProvider provider, Executor executor) {
        this.provider = provider;
        this.executor = executor;
        if (this.executor != null) {
            this.executionHandler = new ExecutionHandler(this.executor);
        }
    }

    protected Object decode(ChannelHandlerContext context, Channel channel, ChannelBuffer buffer, VoidEnum state) throws Exception {
        int nonNewlineBytes = buffer.bytesBefore((byte)10);
        buffer.markReaderIndex();
        if (nonNewlineBytes > 0) {
            ChannelBuffer lineBuffer = buffer.readBytes(nonNewlineBytes);
            String line = lineBuffer.toString(UTF_8);
            buffer.resetReaderIndex();
            ChannelBuffer fullBuffer = null;
            fullBuffer = line.startsWith("CONNECT") || line.startsWith("STOMP") ? this.switchToPureStomp(context, buffer) : this.switchToStompOverWebSockets(context, buffer);
            context.getPipeline().sendUpstream((ChannelEvent)new UpstreamMessageEvent(context.getChannel(), (Object)fullBuffer, context.getChannel().getRemoteAddress()));
        }
        return null;
    }

    protected ChannelBuffer switchToPureStomp(ChannelHandlerContext context, ChannelBuffer buffer) {
        ChannelBuffer fullBuffer = buffer.readBytes(super.actualReadableBytes());
        ChannelPipeline pipeline = context.getPipeline();
        pipeline.remove((ChannelHandler)this);
        pipeline.addLast("stomp-frame-encoder", (ChannelHandler)new StompFrameEncoder());
        pipeline.addLast("stomp-frame-decoder", (ChannelHandler)new StompFrameDecoder());
        this.appendCommonHandlers(pipeline);
        return fullBuffer;
    }

    protected ChannelBuffer switchToStompOverWebSockets(ChannelHandlerContext context, ChannelBuffer buffer) throws NoSuchAlgorithmException {
        ChannelBuffer fullBuffer = buffer.readBytes(super.actualReadableBytes());
        ChannelPipeline pipeline = context.getPipeline();
        pipeline.remove((ChannelHandler)this);
        pipeline.addFirst("disorderly-close", (ChannelHandler)new DisorderlyCloseHandler());
        pipeline.addLast("http-encoder", (ChannelHandler)new HttpResponseEncoder());
        pipeline.addLast("http-decoder", (ChannelHandler)new HttpRequestDecoder());
        pipeline.addLast("websocket-handshake", (ChannelHandler)new ServerHandshakeHandler());
        pipeline.addLast("stomp-frame-encoder", (ChannelHandler)new WebSocketStompFrameEncoder());
        pipeline.addLast("stomp-frame-decoder", (ChannelHandler)new WebSocketStompFrameDecoder());
        this.appendCommonHandlers(pipeline);
        return fullBuffer;
    }

    protected void appendCommonHandlers(ChannelPipeline pipeline) {
        ConnectionContext context = new ConnectionContext();
        pipeline.addLast("stomp-disorderly-close-handler", (ChannelHandler)new StompDisorderlyCloseHandler(this.provider, context));
        pipeline.addLast("stomp-server-connect", (ChannelHandler)new ConnectHandler(this.provider, context));
        pipeline.addLast("stomp-server-disconnect", (ChannelHandler)new DisconnectHandler(this.provider, context));
        pipeline.addLast("stomp-server-subscribe", (ChannelHandler)new SubscribeHandler(this.provider, context));
        pipeline.addLast("stomp-server-unsubscribe", (ChannelHandler)new UnsubscribeHandler(this.provider, context));
        pipeline.addLast("stomp-server-begin", (ChannelHandler)new BeginHandler(this.provider, context));
        pipeline.addLast("stomp-server-commit", (ChannelHandler)new CommitHandler(this.provider, context));
        pipeline.addLast("stomp-server-abort", (ChannelHandler)new AbortHandler(this.provider, context));
        pipeline.addLast("stomp-server-ack", (ChannelHandler)new AckHandler(this.provider, context));
        pipeline.addLast("stomp-server-nack", (ChannelHandler)new NackHandler(this.provider, context));
        pipeline.addLast("stomp-server-receipt", (ChannelHandler)new ReceiptHandler(this.provider, context));
        pipeline.addLast("stomp-message-encoder", (ChannelHandler)new StompMessageEncoder());
        pipeline.addLast("stomp-message-decoder", (ChannelHandler)new StompMessageDecoder((StompMessageFactory)ServerStompMessageFactory.INSTANCE));
        if (this.executionHandler != null) {
            pipeline.addLast("stomp-server-send-threading", (ChannelHandler)this.executionHandler);
        }
        pipeline.addLast("stomp-server-send", (ChannelHandler)new SendHandler(this.provider, context));
    }
}

