/*
 * Decompiled with CFR 0.152.
 */
package org.projectodd.stilts.stomp.server.protocol;

import org.jboss.logging.Logger;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.MessageEvent;
import org.projectodd.stilts.stomp.protocol.StompFrame;
import org.projectodd.stilts.stomp.protocol.StompFrames;
import org.projectodd.stilts.stomp.server.protocol.AbstractProviderHandler;
import org.projectodd.stilts.stomp.server.protocol.ConnectionContext;
import org.projectodd.stilts.stomp.spi.StompProvider;

public class ReceiptHandler
extends AbstractProviderHandler {
    private static Logger log = Logger.getLogger(ReceiptHandler.class);

    public ReceiptHandler(StompProvider server, ConnectionContext context) {
        super(server, context);
    }

    public void messageReceived(ChannelHandlerContext channelContext, MessageEvent e) throws Exception {
        if (e.getMessage() instanceof StompFrame) {
            this.handleStompFrame(channelContext, (StompFrame)e.getMessage());
        }
        super.messageReceived(channelContext, e);
    }

    public void handleStompFrame(ChannelHandlerContext channelContext, StompFrame frame) {
        if (!this.getContext().isActive()) {
            return;
        }
        String receiptId = frame.getHeader("receipt");
        if (receiptId != null) {
            StompFrame receipt = StompFrames.newReceiptFrame((String)receiptId);
            this.sendFrame(channelContext, receipt);
        }
    }
}

