/*
 * Decompiled with CFR 0.152.
 */
package org.projectodd.stilts.stomp.server.protocol;

import org.apache.commons.lang.StringUtils;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.projectodd.stilts.stomp.StompException;
import org.projectodd.stilts.stomp.protocol.StompFrame;
import org.projectodd.stilts.stomp.server.protocol.AbstractControlFrameHandler;
import org.projectodd.stilts.stomp.server.protocol.ConnectionContext;
import org.projectodd.stilts.stomp.spi.StompProvider;

public class UnsubscribeHandler
extends AbstractControlFrameHandler {
    public UnsubscribeHandler(StompProvider server, ConnectionContext context) {
        super(server, context, StompFrame.Command.UNSUBSCRIBE);
    }

    @Override
    public void handleControlFrame(ChannelHandlerContext channelContext, StompFrame frame) {
        String subscriptionId = frame.getHeader("id");
        if (StringUtils.isBlank((String)subscriptionId)) {
            this.sendError(channelContext, "Must supply 'id' header for UNSUBSCRIBE", frame);
            return;
        }
        try {
            this.getStompConnection().unsubscribe(subscriptionId, frame.getHeaders());
        }
        catch (StompException e) {
            this.sendError(channelContext, e.getMessage(), frame);
        }
    }
}

