/*
 * Decompiled with CFR 0.152.
 */
package org.projectodd.stilts.stomp.server.websockets.protocol;

import java.nio.charset.Charset;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jboss.logging.Logger;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelState;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.jboss.netty.channel.UpstreamChannelStateEvent;
import org.jboss.netty.handler.codec.http.Cookie;
import org.jboss.netty.handler.codec.http.CookieDecoder;
import org.jboss.netty.handler.codec.http.DefaultHttpResponse;
import org.jboss.netty.handler.codec.http.HttpHeaders;
import org.jboss.netty.handler.codec.http.HttpMessage;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.handler.codec.http.HttpResponse;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.jboss.netty.handler.codec.http.HttpVersion;
import org.jboss.netty.util.CharsetUtil;
import org.projectodd.stilts.stomp.protocol.websocket.Handshake;
import org.projectodd.stilts.stomp.protocol.websocket.WebSocketDisconnectionNegotiator;
import org.projectodd.stilts.stomp.protocol.websocket.ietf00.Ietf00Handshake;
import org.projectodd.stilts.stomp.protocol.websocket.ietf07.Ietf07Handshake;
import org.projectodd.stilts.stomp.protocol.websocket.ietf08.Ietf08Handshake;
import org.projectodd.stilts.stomp.protocol.websocket.ietf17.Ietf17Handshake;
import org.projectodd.stilts.stomp.server.protocol.HostDecodedEvent;
import org.projectodd.stilts.stomp.server.websockets.protocol.SessionDecodedEvent;

public class ServerHandshakeHandler
extends SimpleChannelUpstreamHandler {
    private static final Logger log = Logger.getLogger((String)"org.torquebox.web.websockets.protocol");
    private List<Handshake> handshakes = new ArrayList<Handshake>();

    public ServerHandshakeHandler() throws NoSuchAlgorithmException {
        this.handshakes.add((Handshake)new Ietf17Handshake(false));
        this.handshakes.add((Handshake)new Ietf07Handshake(false));
        this.handshakes.add((Handshake)new Ietf08Handshake(false));
        this.handshakes.add((Handshake)new Ietf00Handshake());
    }

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        Object msg = e.getMessage();
        if (msg instanceof HttpRequest) {
            this.handleHttpRequest(ctx, (HttpRequest)msg);
        } else {
            super.messageReceived(ctx, e);
        }
    }

    protected void handleHttpRequest(final ChannelHandlerContext channelContext, final HttpRequest request) throws Exception {
        Handshake handshake;
        if (this.isWebSocketsUpgradeRequest(request) && (handshake = this.findHandshake(request)) != null) {
            HttpResponse response = handshake.generateResponse(request);
            response.addHeader("Upgrade", (Object)"WebSocket");
            response.addHeader("Connection", (Object)"Upgrade");
            final ChannelPipeline pipeline = channelContext.getChannel().getPipeline();
            this.reconfigureUpstream(pipeline, handshake);
            Channel channel = channelContext.getChannel();
            ChannelFuture future = channel.write((Object)response);
            future.addListener(new ChannelFutureListener(){

                public void operationComplete(ChannelFuture future) throws Exception {
                    ServerHandshakeHandler.this.reconfigureDownstream(pipeline, handshake);
                    pipeline.replace((ChannelHandler)ServerHandshakeHandler.this, "websocket-disconnection-negotiator", (ChannelHandler)new WebSocketDisconnectionNegotiator());
                    ServerHandshakeHandler.this.forwardConnectEventUpstream(channelContext);
                    ServerHandshakeHandler.this.decodeHost(channelContext, request);
                    ServerHandshakeHandler.this.decodeSession(channelContext, request);
                }
            });
            return;
        }
        this.sendHttpResponse(channelContext, request, (HttpResponse)new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.FORBIDDEN));
    }

    protected void forwardConnectEventUpstream(ChannelHandlerContext channelContext) {
        UpstreamChannelStateEvent connectEvent = new UpstreamChannelStateEvent(channelContext.getChannel(), ChannelState.CONNECTED, (Object)channelContext.getChannel().getRemoteAddress());
        channelContext.sendUpstream((ChannelEvent)connectEvent);
    }

    protected void decodeHost(ChannelHandlerContext channelContext, HttpRequest request) {
        String hostPort = request.getHeader("Host");
        if (hostPort != null) {
            int colonLoc = hostPort.indexOf(58);
            String host = hostPort;
            if (colonLoc > 0) {
                host = hostPort.substring(0, colonLoc);
            }
            HostDecodedEvent hostDecodedEvent = new HostDecodedEvent(channelContext.getChannel(), host);
            channelContext.sendUpstream((ChannelEvent)hostDecodedEvent);
        }
    }

    protected void decodeSession(ChannelHandlerContext channelContext, HttpRequest request) {
        CookieDecoder decoder = new CookieDecoder();
        String cookieHeader = request.getHeader("Cookie");
        if (cookieHeader == null || cookieHeader.trim().equals("")) {
            return;
        }
        Set cookies = decoder.decode(cookieHeader);
        for (Cookie each : cookies) {
            if (!each.getName().equalsIgnoreCase("jsessionid")) continue;
            SessionDecodedEvent sessionDecodedEvent = new SessionDecodedEvent(channelContext.getChannel(), each.getValue());
            channelContext.sendUpstream((ChannelEvent)sessionDecodedEvent);
            break;
        }
    }

    protected Handshake findHandshake(HttpRequest request) {
        for (Handshake handshake : this.handshakes) {
            if (!handshake.matches(request)) continue;
            return handshake;
        }
        return null;
    }

    protected void reconfigureUpstream(ChannelPipeline pipeline, Handshake handshake) {
        pipeline.replace("http-decoder", "websockets-decoder", handshake.newDecoder());
        ChannelHandler[] additionalHandlers = handshake.newAdditionalHandlers();
        String currentTail = "websockets-decoder";
        for (ChannelHandler each : additionalHandlers) {
            String handlerName = "additional-" + each.getClass().getSimpleName();
            pipeline.addAfter(currentTail, handlerName, each);
            currentTail = handlerName;
        }
    }

    protected void reconfigureDownstream(ChannelPipeline pipeline, Handshake handshake) {
        pipeline.replace("http-encoder", "websockets-encoder", handshake.newEncoder());
    }

    protected boolean isWebSocketsUpgradeRequest(HttpRequest request) {
        String connectionHeader = request.getHeader("Connection");
        String upgradeHeader = request.getHeader("Upgrade");
        if (connectionHeader == null || upgradeHeader == null) {
            return false;
        }
        return connectionHeader.trim().toLowerCase().contains("Upgrade".toLowerCase()) && upgradeHeader.trim().equalsIgnoreCase("WebSocket");
    }

    private void sendHttpResponse(ChannelHandlerContext ctx, HttpRequest req, HttpResponse res) {
        if (res.getStatus().getCode() != 200) {
            res.setContent(ChannelBuffers.copiedBuffer((CharSequence)res.getStatus().toString(), (Charset)CharsetUtil.UTF_8));
            HttpHeaders.setContentLength((HttpMessage)res, (long)res.getContent().readableBytes());
        }
        ChannelFuture f = ctx.getChannel().write((Object)res);
        if (!HttpHeaders.isKeepAlive((HttpMessage)req) || res.getStatus().getCode() != 200) {
            f.addListener(ChannelFutureListener.CLOSE);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
        e.getCause().printStackTrace();
        e.getChannel().close();
    }
}

