/*
 * Decompiled with CFR 0.152.
 */
package org.projectodd.stilts.stomplet.container;

import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.projectodd.stilts.stomp.Acknowledger;
import org.projectodd.stilts.stomplet.container.AckSet;

public class CumulativeAckSet
implements AckSet {
    private List<Entry> acknowledgers = new LinkedList<Entry>();

    @Override
    public synchronized void ack(String messageId) throws Exception {
        if (this.hasMessageId(messageId)) {
            ListIterator<Entry> iter = this.acknowledgers.listIterator();
            while (iter.hasNext()) {
                Entry entry = iter.next();
                iter.remove();
                entry.acknowledger.ack();
            }
        }
    }

    @Override
    public synchronized void nack(String messageId) throws Exception {
        if (this.hasMessageId(messageId)) {
            ListIterator<Entry> iter = this.acknowledgers.listIterator();
            while (iter.hasNext()) {
                Entry entry = iter.next();
                iter.remove();
                entry.acknowledger.ack();
            }
        }
    }

    protected boolean hasMessageId(String messageId) {
        for (Entry each : this.acknowledgers) {
            if (!each.messageId.equals(messageId)) continue;
            return true;
        }
        return false;
    }

    @Override
    public synchronized void addAcknowledger(String messageId, Acknowledger acknowledger) {
        this.acknowledgers.add(new Entry(messageId, acknowledger));
    }

    @Override
    public void close() {
        for (Entry each : this.acknowledgers) {
            try {
                each.acknowledger.nack();
            }
            catch (Exception exception) {}
        }
    }

    class Entry {
        public String messageId;
        public Acknowledger acknowledger;

        public Entry(String messageId, Acknowledger acknowledger) {
            this.messageId = messageId;
            this.acknowledger = acknowledger;
        }
    }
}

