/*
 * Decompiled with CFR 0.152.
 */
package org.projectodd.stilts.stomplet.container;

import java.util.HashMap;
import java.util.Map;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAResource;
import org.projectodd.stilts.conduit.spi.MessageConduit;
import org.projectodd.stilts.stomp.Headers;
import org.projectodd.stilts.stomp.StompException;
import org.projectodd.stilts.stomp.StompMessage;
import org.projectodd.stilts.stomp.Subscription;
import org.projectodd.stilts.stomp.spi.AcknowledgeableMessageSink;
import org.projectodd.stilts.stomp.spi.StompSession;
import org.projectodd.stilts.stomplet.container.StompletActivator;
import org.projectodd.stilts.stomplet.container.StompletContainer;

public class StompletMessageConduit
implements MessageConduit {
    private TransactionManager transactionManager;
    private StompletContainer stompletContainer;
    private AcknowledgeableMessageSink messageSink;
    private StompSession session;
    private Map<String, Subscription> subscriptions = new HashMap<String, Subscription>();

    public StompletMessageConduit(TransactionManager transactionManager, StompletContainer stompletContainer, AcknowledgeableMessageSink messageSink, StompSession session) throws StompException {
        this.transactionManager = transactionManager;
        this.stompletContainer = stompletContainer;
        this.messageSink = messageSink;
        this.session = session;
    }

    AcknowledgeableMessageSink getMessageSink() {
        return this.messageSink;
    }

    public StompSession getSession() {
        return this.session;
    }

    public void send(StompMessage message) throws StompException {
        StompletActivator activator = this.stompletContainer.getActivator(message.getDestination());
        if (activator == null) {
            return;
        }
        try {
            Transaction tx = this.transactionManager.getTransaction();
            if (tx != null) {
                for (XAResource each : activator.getXAResources()) {
                    try {
                        tx.enlistResource(each);
                    }
                    catch (IllegalStateException e) {
                        throw new StompException((Throwable)e);
                    }
                    catch (RollbackException e) {
                        throw new StompException((Throwable)e);
                    }
                }
            }
            activator.send(message, this.session);
        }
        catch (SystemException e) {
            throw new StompException((Throwable)e);
        }
    }

    public Subscription subscribe(String subscriptionId, String destination, Headers headers) throws Exception {
        StompletActivator activator = this.stompletContainer.getActivator(destination);
        if (activator == null) {
            return null;
        }
        Subscription subscription = activator.subscribe(this, subscriptionId, destination, headers);
        this.subscriptions.put(subscriptionId, subscription);
        return subscription;
    }
}

