/*
 * Decompiled with CFR 0.152.
 */
package org.projectodd.stilts.stomplet.container;

import java.util.concurrent.atomic.AtomicLong;
import org.projectodd.stilts.stomp.Acknowledger;
import org.projectodd.stilts.stomp.StompException;
import org.projectodd.stilts.stomp.StompMessage;
import org.projectodd.stilts.stomp.Subscription;
import org.projectodd.stilts.stomp.spi.AcknowledgeableMessageSink;
import org.projectodd.stilts.stomp.spi.StompSession;
import org.projectodd.stilts.stomplet.AcknowledgeableStomplet;
import org.projectodd.stilts.stomplet.Stomplet;
import org.projectodd.stilts.stomplet.Subscriber;
import org.projectodd.stilts.stomplet.container.AckSet;
import org.projectodd.stilts.stomplet.container.CumulativeAckSet;
import org.projectodd.stilts.stomplet.container.IndividualAckSet;
import org.projectodd.stilts.stomplet.container.NoOpAcknowledger;
import org.projectodd.stilts.stomplet.container.StompletAcknowledger;
import org.projectodd.stilts.stomplet.container.SubscriberAcknowledger;

public class SubscriberImpl
implements Subscriber {
    private AtomicLong messageCounter = new AtomicLong();
    private StompSession session;
    private Stomplet stomplet;
    private AcknowledgeableMessageSink messageSink;
    private String subscriptionId;
    private String destination;
    private Subscription.AckMode ackMode;
    private AckSet ackSet;

    public SubscriberImpl(StompSession session, Stomplet stomplet, String subscriptionId, String destination, AcknowledgeableMessageSink messageSink, Subscription.AckMode ackMode) {
        this.session = session;
        this.stomplet = stomplet;
        this.subscriptionId = subscriptionId;
        this.destination = destination;
        this.messageSink = messageSink;
        this.ackMode = ackMode;
        if (this.ackMode == Subscription.AckMode.CLIENT) {
            this.ackSet = new CumulativeAckSet();
        } else if (this.ackMode == Subscription.AckMode.CLIENT_INDIVIDUAL) {
            this.ackSet = new IndividualAckSet();
        } else {
            this.ackMode = Subscription.AckMode.AUTO;
        }
    }

    public String getId() {
        return this.subscriptionId;
    }

    public StompSession getSession() {
        return this.session;
    }

    public Subscription.AckMode getAckMode() {
        return this.ackMode;
    }

    public void send(StompMessage message) throws StompException {
        this.send(message, null);
    }

    public void send(StompMessage message, Acknowledger acknowledger) throws StompException {
        StompMessage dupe = message.duplicate();
        dupe.getHeaders().put("subscription", this.subscriptionId);
        dupe.getHeaders().put("message-id", this.getNextMessageId());
        if (acknowledger == null && this.stomplet instanceof AcknowledgeableStomplet) {
            acknowledger = new StompletAcknowledger((AcknowledgeableStomplet)this.stomplet, this, dupe);
        }
        if (this.ackMode == Subscription.AckMode.AUTO) {
            if (acknowledger != null) {
                try {
                    acknowledger.ack();
                }
                catch (Exception e) {
                    throw new StompException((Throwable)e);
                }
            }
            this.messageSink.send(dupe);
        } else {
            if (acknowledger == null) {
                acknowledger = new NoOpAcknowledger();
            }
            this.ackSet.addAcknowledger(dupe.getId(), acknowledger);
            SubscriberAcknowledger subscriberAcknowledger = new SubscriberAcknowledger(this, dupe.getId());
            this.messageSink.send(dupe, (Acknowledger)subscriberAcknowledger);
        }
    }

    void ack(String messageId) throws Exception {
        this.ackSet.ack(messageId);
    }

    void nack(String messageId) throws Exception {
        this.ackSet.nack(messageId);
    }

    void close() {
        if (this.ackSet != null) {
            this.ackSet.close();
        }
    }

    public String getDestination() {
        return this.destination;
    }

    protected String getNextMessageId() {
        return this.subscriptionId + "-message-" + this.messageCounter.getAndIncrement();
    }

    public String toString() {
        return "Subscriber [id=" + this.subscriptionId + ", destination=" + this.destination + ", ackMode=" + this.ackMode + "]";
    }
}

