/*
 * Decompiled with CFR 0.152.
 */
package org.projectodd.stilts.stomplet.container;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.transaction.TransactionManager;
import org.jboss.logging.Logger;
import org.projectodd.stilts.conduit.spi.MessageConduit;
import org.projectodd.stilts.conduit.spi.StompSessionManager;
import org.projectodd.stilts.conduit.spi.TransactionalMessageConduitFactory;
import org.projectodd.stilts.conduit.stomp.SimpleStompSessionManager;
import org.projectodd.stilts.stomp.Headers;
import org.projectodd.stilts.stomp.spi.AcknowledgeableMessageSink;
import org.projectodd.stilts.stomp.spi.StompSession;
import org.projectodd.stilts.stomplet.container.NoSuchHostException;
import org.projectodd.stilts.stomplet.container.StompletContainer;
import org.projectodd.stilts.stomplet.container.StompletMessageConduit;

public class StompletMessageConduitFactory
implements TransactionalMessageConduitFactory {
    private static Logger log = Logger.getLogger(StompletMessageConduitFactory.class);
    private TransactionManager transactionManager;
    private Map<String, StompletContainer> virtualHosts = new HashMap<String, StompletContainer>();
    private Map<String, StompSessionManager> sessionManagers = new HashMap<String, StompSessionManager>();
    private StompletContainer defaultContainer = null;
    private StompSessionManager defaultSessionManager = null;

    public void setTransactionManager(TransactionManager transactionManager) {
        log.debugf("setTransactionManager: %s", (Object)transactionManager);
        this.transactionManager = transactionManager;
    }

    public TransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public MessageConduit createMessageConduit(AcknowledgeableMessageSink messageSink, Headers headers) throws Exception {
        String host = headers.get("host");
        StompletContainer container = null;
        log.debugf("looking for container for host: %s", (Object)host);
        if (host != null) {
            container = this.findStompletContainer(host);
        }
        if (container == null) {
            container = this.defaultContainer;
        }
        if (container == null) {
            throw new NoSuchHostException(host);
        }
        StompSessionManager sessionManager = this.findSessionManager(host);
        if (sessionManager == null) {
            sessionManager = this.defaultSessionManager;
        }
        String sessionId = headers.get("session");
        StompSession session = null;
        if (sessionId != null) {
            session = sessionManager.findSession(sessionId);
        }
        if (session == null) {
            session = sessionManager.createSession();
        }
        return new StompletMessageConduit(this.transactionManager, container, messageSink, session);
    }

    public void registerVirtualHost(String host, StompletContainer container, StompSessionManager sessionManager) {
        this.virtualHosts.put(host.toLowerCase(), container);
        if (sessionManager == null) {
            sessionManager = new SimpleStompSessionManager();
        }
        this.sessionManagers.put(host.toLowerCase(), sessionManager);
    }

    public void unregisterVirtualHost(String host) {
        this.virtualHosts.remove(host.toLowerCase());
        this.sessionManagers.remove(host.toLowerCase());
    }

    public StompletContainer findStompletContainer(String host) {
        return this.virtualHosts.get(host.toLowerCase());
    }

    public StompSessionManager findSessionManager(String host) {
        return this.sessionManagers.get(host.toLowerCase());
    }

    public void setDefaultContainer(StompletContainer container) {
        this.defaultContainer = container;
    }

    public void setDefaultSessionManager(StompSessionManager sessionManager) {
        this.defaultSessionManager = sessionManager;
    }

    public StompletContainer getDefaultContainer() {
        return this.defaultContainer;
    }

    public void start() throws Exception {
        HashSet<StompletContainer> containers = new HashSet<StompletContainer>();
        containers.addAll(this.virtualHosts.values());
        if (this.defaultContainer != null) {
            containers.add(this.defaultContainer);
        }
        for (StompletContainer each : containers) {
            each.start();
        }
    }

    public void stop() throws Exception {
        HashSet<StompletContainer> containers = new HashSet<StompletContainer>();
        containers.addAll(this.virtualHosts.values());
        if (this.defaultContainer != null) {
            containers.add(this.defaultContainer);
        }
        for (StompletContainer each : containers) {
            each.stop();
        }
    }
}

