/*
 * Decompiled with CFR 0.152.
 */
package org.projectodd.stilts.stomplet.container.xa;

import java.util.concurrent.ConcurrentLinkedQueue;
import org.jboss.logging.Logger;
import org.projectodd.stilts.stomp.Acknowledger;
import org.projectodd.stilts.stomp.StompMessage;
import org.projectodd.stilts.stomp.spi.StompSession;
import org.projectodd.stilts.stomplet.Stomplet;

public class PseudoXAStompletTransaction {
    private static Logger log = Logger.getLogger(PseudoXAStompletTransaction.class);
    private Stomplet stomplet;
    private boolean rollbackOnly;
    private ConcurrentLinkedQueue<MessageSend> sentMessages = new ConcurrentLinkedQueue();
    private ConcurrentLinkedQueue<Acknowledger> acks = new ConcurrentLinkedQueue();
    private ConcurrentLinkedQueue<Acknowledger> nacks = new ConcurrentLinkedQueue();

    PseudoXAStompletTransaction(Stomplet stomplet) {
        this.stomplet = stomplet;
    }

    public void setRollbackOnly(boolean rollbackOnly) {
        this.rollbackOnly = rollbackOnly;
    }

    public boolean isRollbackOnly() {
        return this.rollbackOnly;
    }

    boolean isReadOnly() {
        return this.sentMessages.isEmpty() && this.acks.isEmpty() && this.nacks.isEmpty();
    }

    public void addSentMessage(StompMessage message, StompSession session) {
        this.sentMessages.add(new MessageSend(message, session));
    }

    boolean hasSentMessages() {
        return !this.sentMessages.isEmpty();
    }

    public void addAck(Acknowledger acknowledger) {
        this.acks.add(acknowledger);
    }

    boolean hasAcks() {
        return !this.acks.isEmpty();
    }

    public void addNack(Acknowledger acknowledger) {
        this.nacks.add(acknowledger);
    }

    boolean hasNacks() {
        return !this.nacks.isEmpty();
    }

    public void commit() {
        for (MessageSend messageSend : this.sentMessages) {
            try {
                this.stomplet.onMessage(messageSend.message, messageSend.session);
            }
            catch (Exception e) {
                log.errorf((Throwable)e, "Cannot send message: %s", (Object)messageSend);
            }
        }
        this.sentMessages.clear();
        for (Acknowledger acknowledger : this.acks) {
            try {
                acknowledger.ack();
            }
            catch (Exception e) {
                log.errorf((Throwable)e, "Cannot ack: %s", (Object)acknowledger);
            }
        }
        this.acks.clear();
        for (Acknowledger acknowledger : this.nacks) {
            try {
                acknowledger.nack();
            }
            catch (Exception e) {
                log.errorf((Throwable)e, "Cannot nack: %s", (Object)acknowledger);
            }
        }
        this.nacks.clear();
    }

    public void rollback() {
        this.sentMessages.clear();
        this.acks.clear();
    }

    private static class MessageSend {
        StompMessage message;
        StompSession session;

        MessageSend(StompMessage message, StompSession session) {
            this.message = message;
            this.session = session;
        }
    }
}

