/*
 * Decompiled with CFR 0.152.
 */
package org.projectodd.stilts.stomplet.parser;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.projectodd.stilts.stomplet.parser.RouteConfiguration;

public class StompletConfParser {
    private Pattern ROUTE_PATTERN = Pattern.compile("^ROUTE ([^\\s]+) ([^\\s]+)$");
    private BufferedReader reader;

    public StompletConfParser(InputStream in) {
        this.reader = new BufferedReader(new InputStreamReader(in));
    }

    public List<RouteConfiguration> parse() throws IOException {
        ArrayList<RouteConfiguration> configs = new ArrayList<RouteConfiguration>();
        String line = null;
        while ((line = this.readLine(true)) != null) {
            RouteConfiguration config = null;
            Matcher matcher = this.ROUTE_PATTERN.matcher(line);
            if (!matcher.matches()) continue;
            String pattern = matcher.group(1);
            String className = matcher.group(2);
            config = new RouteConfiguration(pattern, className);
            configs.add(config);
            while ((line = this.readLine(false)) != null && !"".equals(line)) {
                String[] values = line.split(":");
                config.getProperties().put(values[0], values[1]);
            }
        }
        return configs;
    }

    protected String readLine() throws IOException {
        return this.readLine(false);
    }

    protected String readLine(boolean skipBlanks) throws IOException {
        String line = null;
        while ((line = this.reader.readLine()) != null) {
            int hashLoc = line.indexOf("#");
            if (hashLoc >= 0) {
                line = line.substring(0, hashLoc);
            }
            line = line.trim();
            if (!skipBlanks) {
                return line;
            }
            if (line.equals("")) continue;
            return line;
        }
        return line;
    }
}

