/*
 * Decompiled with CFR 0.152.
 */
package org.python.netty.channel;

import java.util.Map;
import java.util.WeakHashMap;
import org.python.netty.channel.ChannelHandler;
import org.python.netty.channel.ChannelHandlerContext;
import org.python.netty.util.internal.FastThreadLocal;

public abstract class ChannelHandlerAdapter
implements ChannelHandler {
    private static final ThreadLocal<Map<Class<?>, Boolean>> SHARABLE_CACHE = new FastThreadLocal<Map<Class<?>, Boolean>>(){

        @Override
        protected Map<Class<?>, Boolean> initialValue() {
            return new WeakHashMap(4);
        }
    };
    boolean added;

    public boolean isSharable() {
        Class<?> clazz = this.getClass();
        Map<Class<?>, Boolean> cache = SHARABLE_CACHE.get();
        Boolean sharable = cache.get(clazz);
        if (sharable == null) {
            sharable = clazz.isAnnotationPresent(ChannelHandler.Sharable.class);
            cache.put(clazz, sharable);
        }
        return sharable;
    }

    @Override
    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
    }

    @Override
    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        ctx.fireExceptionCaught(cause);
    }
}

